/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.AbstractNumberVectorDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.BetaDistribution;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.AllOrNoneMustBeSetGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.EqualSizeGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Arrays;
import java.util.Random;

@Reference(authors="B. Hopkins and J. G. Skellam", title="A new method for determining the type of distribution of plant individuals", booktitle="Annals of Botany, 18(2), 213-227", url="http://aob.oxfordjournals.org/content/18/2/213.short")
public class HopkinsStatisticClusteringTendency
extends AbstractNumberVectorDistanceBasedAlgorithm<NumberVector, Result> {
    private static final Logging LOG = Logging.getLogger(HopkinsStatisticClusteringTendency.class);
    protected int sampleSize;
    protected int rep;
    protected int k;
    protected RandomFactory random;
    private double[] maxima = new double[0];
    private double[] minima = new double[0];

    public HopkinsStatisticClusteringTendency(NumberVectorDistanceFunction<? super NumberVector> numberVectorDistanceFunction, int n, RandomFactory randomFactory, int n2, int n3, double[] dArray, double[] dArray2) {
        super(numberVectorDistanceFunction);
        this.sampleSize = n;
        this.random = randomFactory;
        this.rep = n2;
        this.k = n3;
        this.minima = dArray;
        this.maxima = dArray2;
    }

    public Result run(Database database, Relation<NumberVector> relation) {
        double d;
        double d2;
        double d3;
        int n = RelationUtil.dimensionality(relation);
        DistanceQuery<NumberVector> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<NumberVector> kNNQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        this.initializeDataExtends(relation, n, dArray, dArray2);
        if (!LOG.isStatistics()) {
            LOG.warning("This algorithm must be used with at least logging level " + Logging.Level.STATISTICS);
        }
        MeanVariance meanVariance = new MeanVariance();
        MeanVariance meanVariance2 = new MeanVariance();
        MeanVariance meanVariance3 = new MeanVariance();
        for (int i = 0; i < this.rep; ++i) {
            d3 = this.computeNNForRealData(kNNQuery, relation, n);
            d2 = this.computeNNForUniformData(kNNQuery, dArray, dArray2);
            d = d2 / (d2 + d3);
            meanVariance.put(d);
            meanVariance2.put(d2);
            meanVariance3.put(d3);
        }
        String string = this.getClass().getName();
        LOG.statistics(new LongStatistic(string + ".samplesize", this.sampleSize));
        LOG.statistics(new LongStatistic(string + ".dim", n));
        LOG.statistics(new LongStatistic(string + ".hopkins.nearest-neighbor", this.k));
        LOG.statistics(new DoubleStatistic(string + ".hopkins.h.mean", meanVariance.getMean()));
        LOG.statistics(new DoubleStatistic(string + ".hopkins.u.mean", meanVariance2.getMean()));
        LOG.statistics(new DoubleStatistic(string + ".hopkins.w.mean", meanVariance3.getMean()));
        if (this.rep > 1) {
            LOG.statistics(new DoubleStatistic(string + ".hopkins.h.std", meanVariance.getSampleStddev()));
            LOG.statistics(new DoubleStatistic(string + ".hopkins.u.std", meanVariance2.getSampleStddev()));
            LOG.statistics(new DoubleStatistic(string + ".hopkins.w.std", meanVariance3.getSampleStddev()));
        }
        d3 = meanVariance.getMean();
        d2 = BetaDistribution.regularizedIncBeta(d3, this.sampleSize, this.sampleSize);
        d = d3 > 0.5 ? 1.0 - d2 : d2;
        LOG.statistics(new DoubleStatistic(string + ".hopkins.p", d));
        return null;
    }

    protected double computeNNForRealData(KNNQuery<NumberVector> kNNQuery, Relation<NumberVector> relation, int n) {
        double d = 0.0;
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample(relation.getDBIDs(), this.sampleSize, this.random);
        DBIDMIter dBIDMIter = modifiableDBIDs.iter();
        while (dBIDMIter.valid()) {
            double d2 = kNNQuery.getKNNForDBID(dBIDMIter, this.k + 1).getKNNDistance();
            d += MathUtil.powi(d2, n);
            dBIDMIter.advance();
        }
        return d;
    }

    protected double computeNNForUniformData(KNNQuery<NumberVector> kNNQuery, double[] dArray, double[] dArray2) {
        Random random = this.random.getSingleThreadedRandom();
        int n = dArray.length;
        Vector vector = new Vector(n);
        double[] dArray3 = vector.getArrayRef();
        double d = 0.0;
        for (int i = 0; i < this.sampleSize; ++i) {
            for (int j = 0; j < dArray3.length; ++j) {
                dArray3[j] = dArray[j] + random.nextDouble() * dArray2[j];
            }
            double d2 = kNNQuery.getKNNForObject(vector, this.k).getKNNDistance();
            d += MathUtil.powi(d2, n);
        }
        return d;
    }

    protected void initializeDataExtends(Relation<NumberVector> relation, int n, double[] dArray, double[] dArray2) {
        assert (dArray.length == n && dArray2.length == n);
        if (this.minima == null || this.maxima == null || this.minima.length == 0 || this.maxima.length == 0) {
            double[][] dArray3 = RelationUtil.computeMinMax(relation);
            double[] dArray4 = dArray3[0];
            double[] dArray5 = dArray3[1];
            for (int i = 0; i < n; ++i) {
                dArray[i] = dArray4[i];
                dArray2[i] = dArray5[i] - dArray4[i];
            }
            return;
        }
        if (this.minima.length == n) {
            System.arraycopy(this.minima, 0, dArray, 0, n);
        } else if (this.minima.length == 1) {
            Arrays.fill(dArray, this.minima[0]);
        } else {
            throw new AbortException("Invalid minima specified: expected " + n + " got minima dimensionality: " + this.minima.length);
        }
        if (this.maxima.length == n) {
            for (int i = 0; i < n; ++i) {
                dArray2[i] = this.maxima[i] - dArray[i];
            }
            return;
        }
        if (this.maxima.length == 1) {
            for (int i = 0; i < n; ++i) {
                dArray2[i] = this.maxima[0] - dArray[i];
            }
            return;
        }
        throw new AbortException("Invalid maxima specified: expected " + n + " got maxima dimensionality: " + this.maxima.length);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer
    extends AbstractNumberVectorDistanceBasedAlgorithm.Parameterizer<NumberVector> {
        public static final OptionID SAMPLESIZE_ID = new OptionID("hopkins.samplesize", "Number of object / random samples to analyze.");
        public static final OptionID REP_ID = new OptionID("hopkins.rep", "The number of times to repeat the experiment (default: 1)");
        public static final OptionID SEED_ID = new OptionID("hopkins.seed", "The random number generator.");
        public static final OptionID MINIMA_ID = new OptionID("hopkins.min", "Minimum values in each dimension. If no value is specified, the minimum value in each dimension will be used. If only one value is specified, this value will be used for all dimensions.");
        public static final OptionID MAXIMA_ID = new OptionID("hopkins.max", "Maximum values in each dimension. If no value is specified, the maximum value in each dimension will be used. If only one value is specified, this value will be used for all dimensions.");
        public static final OptionID K_ID = new OptionID("hopkins.k", "Nearest neighbor to use for the statistic");
        protected int sampleSize = 0;
        protected int rep = 1;
        protected int k = 1;
        protected RandomFactory random;
        private double[] maxima = null;
        private double[] minima = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleListParameter doubleListParameter;
            DoubleListParameter doubleListParameter2;
            RandomParameter randomParameter;
            IntParameter intParameter;
            IntParameter intParameter2;
            IntParameter intParameter3;
            ObjectParameter objectParameter = AbstractAlgorithm.makeParameterDistanceFunction(EuclideanDistanceFunction.class, NumberVectorDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distanceFunction = (NumberVectorDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(intParameter3 = (IntParameter)new IntParameter(REP_ID, 1).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.rep = (Integer)intParameter3.getValue();
            }
            if (parameterization.grab(intParameter2 = (IntParameter)new IntParameter(K_ID, 1).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.k = (Integer)intParameter2.getValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(SAMPLESIZE_ID))) {
                this.sampleSize = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
            if (parameterization.grab(doubleListParameter2 = (DoubleListParameter)new DoubleListParameter(MINIMA_ID).setOptional(true))) {
                this.minima = (double[])((double[])doubleListParameter2.getValue()).clone();
            }
            if (parameterization.grab(doubleListParameter = (DoubleListParameter)new DoubleListParameter(MAXIMA_ID).setOptional(true))) {
                this.maxima = (double[])((double[])doubleListParameter.getValue()).clone();
            }
            parameterization.checkConstraint(new AllOrNoneMustBeSetGlobalConstraint(doubleListParameter2, doubleListParameter));
            parameterization.checkConstraint(new EqualSizeGlobalConstraint(doubleListParameter2, doubleListParameter));
        }

        @Override
        protected HopkinsStatisticClusteringTendency makeInstance() {
            return new HopkinsStatisticClusteringTendency(this.distanceFunction, this.sampleSize, this.random, this.rep, this.k, this.minima, this.maxima);
        }
    }
}

