/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.uncertain.SimpleGaussianContinuousUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.Random;

public class SimpleGaussianUncertainifier
implements Uncertainifier<SimpleGaussianContinuousUncertainObject> {
    double minDev;
    double maxDev;
    boolean symmetric;

    public SimpleGaussianUncertainifier(double d, double d2, boolean bl) {
        this.minDev = d;
        this.maxDev = d2;
    }

    @Override
    public <A> SimpleGaussianContinuousUncertainObject newFeatureVector(Random random, A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        if (this.symmetric) {
            for (int i = 0; i < n; ++i) {
                double d = numberArrayAdapter.getDouble(a, i);
                double d2 = random.nextDouble() * (this.maxDev - this.minDev) + this.minDev;
                dArray[i] = d - d2;
                dArray2[i] = d + d2;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double d = random.nextDouble() * (this.maxDev - this.minDev) + this.minDev;
                double d3 = numberArrayAdapter.getDouble(a, i) + random.nextGaussian() * d;
                dArray[i] = d3 - d;
                dArray2[i] = d3 + d;
            }
        }
        return new SimpleGaussianContinuousUncertainObject(new HyperBoundingBox(dArray, dArray2));
    }

    @Override
    public FeatureVector.Factory<SimpleGaussianContinuousUncertainObject, ?> getFactory() {
        return SimpleGaussianContinuousUncertainObject.FACTORY;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DEV_MIN_ID = new OptionID("uo.uncertainty.min3sigma", "Minimum 3-sigma deviation of uncertain region.");
        public static final OptionID DEV_MAX_ID = new OptionID("uo.uncertainty.max3sigma", "Maximum 3-sigma deviation of uncertain region.");
        protected double minDev;
        protected double maxDev;
        protected boolean symmetric;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(DEV_MIN_ID, 0.0);
            if (parameterization.grab(doubleParameter2)) {
                this.minDev = (Double)doubleParameter2.getValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(DEV_MAX_ID))) {
                this.maxDev = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(flag = new Flag(Uncertainifier.SYMMETRIC_ID))) {
                this.symmetric = flag.isTrue();
            }
        }

        @Override
        protected SimpleGaussianUncertainifier makeInstance() {
            return new SimpleGaussianUncertainifier(this.minDev, this.maxDev, this.symmetric);
        }
    }
}

