/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Longest Common Subsequence distance function")
@Reference(authors="M. Vlachos, M. Hadjieleftheriou, D. Gunopulos, E. Keogh", title="Indexing Multi-Dimensional Time-Series with Support for Multiple Distance Measures", booktitle="Proceedings of the ninth ACM SIGKDD international conference on Knowledge discovery and data mining", url="http://dx.doi.org/10.1145/956750.956777")
public class LCSSDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    private double pDelta;
    private double pEpsilon;

    public LCSSDistanceFunction(double d, double d2) {
        this.pDelta = d;
        this.pEpsilon = d2;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2 = numberVector.getDimensionality();
        if (n2 > (n = numberVector2.getDimensionality())) {
            return this.distance(numberVector2, numberVector);
        }
        int n3 = (int)Math.ceil((double)n * this.pDelta);
        double d = this.getRange(numberVector, n2, numberVector2, n) * this.pEpsilon;
        double[] dArray = new double[n + 1];
        double[] dArray2 = new double[n + 1];
        for (int i = 0; i < n2; ++i) {
            double d2 = numberVector.doubleValue(i);
            for (int j = Math.max(0, i - n3); j <= Math.min(n - 1, i + n3); ++j) {
                double d3 = numberVector2.doubleValue(j);
                dArray2[j + 1] = d3 + d >= d2 && d3 - d <= d2 ? dArray[j] + 1.0 : (dArray[j + 1] > dArray2[j] ? dArray[j + 1] : dArray2[j]);
            }
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        double d4 = dArray[1];
        for (int i = 2; i < n + 1; ++i) {
            d4 = dArray[i] > d4 ? dArray[i] : d4;
        }
        double d5 = d4 / (double)Math.min(n2, n);
        return 1.0 - d5;
    }

    public double getRange(NumberVector numberVector, int n, NumberVector numberVector2, int n2) {
        double d;
        int n3;
        double d2;
        double d3 = d2 = numberVector.doubleValue(0);
        for (n3 = 1; n3 < n; ++n3) {
            d = numberVector.doubleValue(n3);
            d2 = d < d2 ? d : d2;
            d3 = d > d3 ? d : d3;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            d = numberVector2.doubleValue(n3);
            d2 = d < d2 ? d : d2;
            d3 = d > d3 ? d : d3;
        }
        double d4 = d3 - d2;
        return d4;
    }

    @Override
    public VectorTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.pDelta == ((LCSSDistanceFunction)object).pDelta && this.pEpsilon == ((LCSSDistanceFunction)object).pEpsilon;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PDELTA_ID = new OptionID("lcss.pDelta", "the allowed deviation in x direction for LCSS alignment (positive double value, 0 <= pDelta <= 1)");
        public static final OptionID PEPSILON_ID = new OptionID("lcss.pEpsilon", "the allowed deviation in y direction for LCSS alignment (positive double value, 0 <= pEpsilon <= 1)");
        private double pDelta;
        private double pEpsilon;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = (DoubleParameter)((DoubleParameter)new DoubleParameter(PDELTA_ID, 0.1).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter2)) {
                this.pDelta = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(PEPSILON_ID, 0.05).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE))) {
                this.pEpsilon = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LCSSDistanceFunction makeInstance() {
            return new LCSSDistanceFunction(this.pDelta, this.pEpsilon);
        }
    }
}

