/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores;

import de.lmu.ifi.dbs.elki.evaluation.scores.AbstractScoreEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class MaximumF1Evaluation
extends AbstractScoreEvaluation {
    public static final MaximumF1Evaluation STATIC = new MaximumF1Evaluation();

    @Override
    public <I extends ScoreEvaluation.ScoreIter> double evaluate(ScoreEvaluation.Predicate<? super I> predicate, I i) {
        int n = predicate.numPositive();
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        while (i.valid()) {
            do {
                if (predicate.test(i)) {
                    ++n2;
                }
                ++n3;
                i.advance();
            } while (i.valid() && i.tiedToPrevious());
            double d2 = (double)n2 / (double)n3;
            double d3 = (double)n2 / (double)n;
            double d4 = 2.0 * d2 * d3 / (d2 + d3);
            if (!(d4 > d)) continue;
            d = d4;
        }
        return d;
    }

    @Override
    public double expected(int n, int n2) {
        return (double)n / (double)n2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MaximumF1Evaluation makeInstance() {
            return STATIC;
        }
    }
}

