/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.AbstractSingleParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.ConfiguratorPanel;
import de.lmu.ifi.dbs.elki.gui.icons.StockIcon;
import de.lmu.ifi.dbs.elki.gui.util.ClassTree;
import de.lmu.ifi.dbs.elki.gui.util.TreePopup;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassParameterConfigurator
extends AbstractSingleParameterConfigurator<ClassParameter<?>>
implements ActionListener,
ChangeListener {
    final JPanel panel;
    final JTextField textfield = new JTextField();
    final JButton button;
    final TreePopup popup;
    final ConfiguratorPanel child;

    public ClassParameterConfigurator(ClassParameter<?> classParameter, JComponent jComponent) {
        super(classParameter, jComponent);
        this.textfield.setToolTipText(((ClassParameter)this.param).getShortDescription());
        if (classParameter.isDefined() && !classParameter.tookDefaultValue()) {
            this.textfield.setText(classParameter.getValueAsString());
        }
        this.textfield.setPreferredSize(new Dimension(400, this.textfield.getPreferredSize().height));
        if (!((ClassParameter)this.param).tookDefaultValue() && ((ClassParameter)this.param).isDefined() && ((ClassParameter)this.param).getGivenValue() != null) {
            this.textfield.setText(((ClassParameter)this.param).getValueAsString());
        }
        this.button = UIManager.getLookAndFeel().getName().indexOf("GTK") >= 0 ? new JButton(StockIcon.getStockIcon("edit-find")) : new BasicArrowButton(5);
        this.button.setToolTipText(((ClassParameter)this.param).getShortDescription());
        this.button.addActionListener(this);
        TreeNode treeNode = ClassTree.build(classParameter.getKnownImplementations(), classParameter.getRestrictionClass().getPackage().getName());
        this.popup = new TreePopup(new DefaultTreeModel(treeNode));
        this.popup.getTree().setRootVisible(false);
        this.popup.addActionListener(this);
        Icon icon = StockIcon.getStockIcon("go-next");
        Icon icon2 = StockIcon.getStockIcon("package");
        TreePopup.Renderer renderer = (TreePopup.Renderer)this.popup.getTree().getCellRenderer();
        renderer.setLeafIcon(icon);
        renderer.setFolderIcon(icon2);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.textfield, "Center");
        this.panel.add((Component)this.button, "East");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jComponent.add((Component)this.panel, gridBagConstraints);
        this.finishGridRow();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.child = new ConfiguratorPanel();
        this.child.addChangeListener(this);
        jComponent.add((Component)this.child, gridBagConstraints);
    }

    @Override
    public void addParameter(Object object, Parameter<?> parameter, TrackParameters trackParameters) {
        this.child.addParameter(object, parameter, trackParameters);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.button) {
            this.popup.show(this.panel);
            return;
        }
        if (actionEvent.getSource() == this.popup) {
            Object object;
            if (actionEvent.getActionCommand() == "canceled") {
                this.popup.setVisible(false);
                this.textfield.requestFocus();
                return;
            }
            TreePath treePath = this.popup.getTree().getSelectionPath();
            Object object2 = object = treePath != null ? treePath.getLastPathComponent() : null;
            if (object instanceof ClassTree.ClassNode) {
                String string;
                ClassTree.ClassNode classNode = treePath != null ? (ClassTree.ClassNode)object : null;
                String string2 = string = classNode != null ? classNode.getClassName() : null;
                if (string != null && string.length() > 0) {
                    this.textfield.setText(string);
                    this.popup.setVisible(false);
                    this.fireValueChanged();
                }
            }
            return;
        }
        LoggingUtil.warning("actionPerformed triggered by unknown source: " + actionEvent.getSource());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.child) {
            this.fireValueChanged();
            return;
        }
        LoggingUtil.warning("stateChanged triggered by unknown source: " + changeEvent.getSource());
    }

    @Override
    public String getUserInput() {
        String string = this.textfield.getText();
        if (string.startsWith("Default: ")) {
            return null;
        }
        if ("(optional)".equals(string)) {
            return null;
        }
        return string;
    }

    @Override
    public void appendParameters(ListParameterization listParameterization) {
        super.appendParameters(listParameterization);
        this.child.appendParameters(listParameterization);
    }
}

