/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;

public class XYCurve
implements Result,
TextWriteable {
    protected static final double THRESHOLD = 1.0E-13;
    protected DoubleArray data;
    protected String labelx;
    protected String labely;
    protected double minx = Double.POSITIVE_INFINITY;
    protected double maxx = Double.NEGATIVE_INFINITY;
    protected double miny = Double.POSITIVE_INFINITY;
    protected double maxy = Double.NEGATIVE_INFINITY;

    public XYCurve(String string, String string2) {
        this.data = new DoubleArray();
        this.labelx = string;
        this.labely = string2;
    }

    public XYCurve(String string, String string2, int n) {
        this.data = new DoubleArray(n << 1);
        this.labelx = string;
        this.labely = string2;
    }

    public XYCurve() {
        this("X", "Y");
    }

    public XYCurve(int n) {
        this("X", "Y", n);
    }

    public XYCurve(XYCurve xYCurve) {
        this.data = new DoubleArray(xYCurve.data);
        this.labelx = xYCurve.labelx;
        this.labely = xYCurve.labely;
        this.minx = xYCurve.minx;
        this.maxx = xYCurve.maxx;
        this.miny = xYCurve.miny;
        this.maxy = xYCurve.maxy;
    }

    public void add(double d, double d2) {
        this.data.add(d);
        this.data.add(d2);
        this.minx = Math.min(this.minx, d);
        this.maxx = Math.max(this.maxx, d);
        this.miny = Math.min(this.miny, d2);
        this.maxy = Math.max(this.maxy, d2);
    }

    public void addAndSimplify(double d, double d2) {
        int n = this.data.size();
        if (n >= 4) {
            double d3 = this.data.get(n - 4);
            double d4 = this.data.get(n - 3);
            double d5 = this.data.get(n - 2);
            double d6 = this.data.get(n - 1);
            double d7 = d5 - d3;
            double d8 = d6 - d4;
            double d9 = d - d5;
            double d10 = d2 - d6;
            if (d7 == 0.0 && d9 == 0.0) {
                this.data.remove(n - 2, 2);
            } else if (d8 == 0.0 && d10 == 0.0) {
                this.data.remove(n - 2, 2);
            } else if (d8 > 0.0 && d10 > 0.0 && Math.abs(d7 / d8 - d9 / d10) < 1.0E-13) {
                this.data.remove(n - 2, 2);
            }
        }
        this.add(d, d2);
    }

    public String getLabelx() {
        return this.labelx;
    }

    public String getLabely() {
        return this.labely;
    }

    public double getMinx() {
        return this.minx;
    }

    public double getMaxx() {
        return this.maxx;
    }

    public double getMiny() {
        return this.miny;
    }

    public double getMaxy() {
        return this.maxy;
    }

    public double getX(int n) {
        return this.data.get(n << 1);
    }

    public double getY(int n) {
        return this.data.get((n << 1) + 1);
    }

    public void rescale(double d, double d2) {
        for (int i = 0; i < this.data.size(); i += 2) {
            this.data.set(i, d * this.data.get(i));
            this.data.set(i + 1, d2 * this.data.get(i + 1));
        }
        this.maxx *= d;
        this.maxy *= d2;
    }

    public int size() {
        return this.data.size() >> 1;
    }

    public Itr iterator() {
        return new Itr();
    }

    @Override
    public void writeToText(TextWriterStream textWriterStream, String string) {
        textWriterStream.commentPrint(this.labelx);
        textWriterStream.commentPrint(" ");
        textWriterStream.commentPrint(this.labely);
        textWriterStream.flush();
        for (int i = 0; i < this.data.size(); i += 2) {
            textWriterStream.inlinePrint(Double.toString(this.data.get(i)));
            textWriterStream.inlinePrint(Double.toString(this.data.get(i + 1)));
            textWriterStream.flush();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("XYCurve[");
        stringBuilder.append(this.labelx).append(',').append(this.labely).append(':');
        for (int i = 0; i < this.data.size(); i += 2) {
            stringBuilder.append(' ').append(this.data.get(i)).append(',').append(this.data.get(i + 1));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getLongName() {
        return this.labelx + "-" + this.labely + "-Curve";
    }

    @Override
    public String getShortName() {
        return (this.labelx + "-" + this.labely + "-curve").toLowerCase();
    }

    public static double areaUnderCurve(XYCurve xYCurve) {
        DoubleArray doubleArray = xYCurve.data;
        double d = doubleArray.get(0);
        double d2 = doubleArray.get(1);
        if (d > xYCurve.minx) {
            throw new UnsupportedOperationException("Curves must be monotone on X for areaUnderCurve to be valid.");
        }
        double d3 = 0.0;
        for (int i = 2; i < doubleArray.size(); i += 2) {
            double d4 = doubleArray.get(i);
            double d5 = doubleArray.get(i + 1);
            if (d > d4) {
                throw new UnsupportedOperationException("Curves must be monotone on X for areaUnderCurve to be valid.");
            }
            d3 += (d4 - d) * (d2 + d5) * 0.5;
            d = d4;
            d2 = d5;
        }
        if (d < xYCurve.maxx) {
            throw new UnsupportedOperationException("Curves must be complete on X for areaUnderCurve to be valid.");
        }
        return d3;
    }

    public class Itr {
        protected int pos = 0;

        public double getX() {
            return XYCurve.this.data.get(this.pos);
        }

        public double getY() {
            return XYCurve.this.data.get(this.pos + 1);
        }

        public void advance() {
            this.pos += 2;
        }

        public boolean valid() {
            return this.pos < XYCurve.this.data.size();
        }
    }
}

