/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter.naming;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.result.textwriter.naming.NamingScheme;
import java.util.HashMap;
import java.util.Map;

public class SimpleEnumeratingScheme
implements NamingScheme {
    private Clustering<?> clustering;
    private Map<String, Integer> namecount = new HashMap<String, Integer>();
    private Map<Cluster<?>, String> names = new HashMap();
    private static final String nullpostfix = " " + Integer.toString(0);

    public SimpleEnumeratingScheme(Clustering<?> clustering) {
        this.clustering = clustering;
        this.updateNames();
    }

    private void updateNames() {
        for (Cluster<?> cluster : this.clustering.getAllClusters()) {
            if (this.names.get(cluster) != null) continue;
            String string = cluster.getNameAutomatic();
            Integer n = this.namecount.get(string);
            if (n == null) {
                n = new Integer(0);
            }
            this.names.put(cluster, string + " " + n.toString());
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
            this.namecount.put(string, n);
        }
    }

    @Override
    public String getNameFor(Cluster<?> cluster) {
        String string = this.names.get(cluster);
        if (string == null) {
            this.updateNames();
            string = this.names.get(cluster);
        }
        if (string.endsWith(nullpostfix) && this.namecount.get(string.substring(0, string.length() - nullpostfix.length())) == 1) {
            string = string.substring(0, string.length() - nullpostfix.length());
        }
        return string;
    }
}

