/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class Sphere
extends AbstractDoubleProblem {
    public Sphere() {
        this(10);
    }

    public Sphere(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(1);
        this.setName("Sphere");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-5.12);
            upperLimit.add(5.12);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] f = new double[this.getNumberOfObjectives()];
        double[] x = new double[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        double sum = 0.0;
        for (int var = 0; var < numberOfVariables; ++var) {
            double value = x[var];
            sum += value * value;
        }
        solution.setObjective(0, sum);
    }
}

