/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.FourC;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.AbstractRangeQueryNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.PreDeConNeighborPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.LimitEigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredRunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.StandardCovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="C. B\u00f6hm, K. Kailing, P. Kr\u00f6ger, A. Zimek", title="Computing Clusters of Correlation Connected Objects", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data, Paris, France, 2004, 455-466", url="http://dx.doi.org/10.1145/1007568.1007620")
public class FourCNeighborPredicate<V extends NumberVector>
extends AbstractRangeQueryNeighborPredicate<V, PreDeConNeighborPredicate.PreDeConModel> {
    private static final Logging LOG = Logging.getLogger(FourCNeighborPredicate.class);
    private FourC.Settings settings;
    private MeanVariance mvSize = new MeanVariance();
    private MeanVariance mvSize2 = new MeanVariance();
    private MeanVariance mvCorDim = new MeanVariance();
    private PCAFilteredRunner pca;

    public FourCNeighborPredicate(FourC.Settings settings) {
        super(settings.epsilon, EuclideanDistanceFunction.STATIC);
        this.settings = settings;
        this.pca = new PCAFilteredRunner(new StandardCovarianceMatrixBuilder(), new LimitEigenPairFilter(settings.delta, settings.absolute), settings.kappa, 1.0);
    }

    @Override
    public <T> NeighborPredicate.Instance<T> instantiate(Database database, SimpleTypeInformation<?> simpleTypeInformation) {
        DistanceQuery distanceQuery = QueryUtil.getDistanceQuery(database, this.distFunc, new Object[0]);
        Relation relation = distanceQuery.getRelation();
        RangeQuery rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        this.mvSize.reset();
        this.mvSize2.reset();
        this.mvCorDim.reset();
        DataStore<PreDeConNeighborPredicate.PreDeConModel> dataStore = this.preprocess(PreDeConNeighborPredicate.PreDeConModel.class, relation, rangeQuery);
        if (LOG.isVerbose()) {
            LOG.verbose("Average neighborhood size: " + this.mvSize.toString());
            LOG.verbose("Average correlation dimensionality: " + this.mvCorDim.toString());
            LOG.verbose("Average correlated neighborhood size: " + this.mvSize2.toString());
            int n = RelationUtil.dimensionality(relation);
            if (this.mvSize.getMean() < (double)(5 * n)) {
                LOG.verbose("The epsilon parameter may be chosen too small.");
            } else if (this.mvSize.getMean() > 0.5 * (double)relation.size()) {
                LOG.verbose("The epsilon parameter may be chosen too large.");
            } else if (this.mvSize2.getMean() < 10.0) {
                LOG.verbose("The epsilon parameter may be chosen too large, or delta too small.");
            } else if (this.mvSize2.getMean() < (double)this.settings.minpts) {
                LOG.verbose("The minPts parameter may be chosen too large.");
            } else {
                LOG.verbose("As a first guess, you can try minPts < " + (int)this.mvSize2.getMean() + ", but you will need to experiment with these parameters and epsilon.");
            }
        }
        return new Instance(distanceQuery.getRelation().getDBIDs(), dataStore);
    }

    @Override
    protected PreDeConNeighborPredicate.PreDeConModel computeLocalModel(DBIDRef dBIDRef, DoubleDBIDList doubleDBIDList, Relation<V> relation) {
        this.mvSize.put(doubleDBIDList.size());
        PCAResult pCAResult = this.pca.processIds((DBIDs)doubleDBIDList, relation);
        int n = ((PCAFilteredResult)pCAResult).getCorrelationDimension();
        Matrix matrix = ((PCAFilteredResult)pCAResult).similarityMatrix();
        Vector vector = ((NumberVector)relation.get(dBIDRef)).getColumnVector();
        double d = this.settings.epsilon * this.settings.epsilon;
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(doubleDBIDList.size());
        DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
        while (doubleDBIDListIter.valid()) {
            Vector vector2 = ((NumberVector)relation.get(doubleDBIDListIter)).getColumnVector().minusEquals(vector);
            double d2 = vector2.transposeTimesTimes(matrix, vector2);
            if (d2 <= d) {
                hashSetModifiableDBIDs.add(doubleDBIDListIter);
            }
            doubleDBIDListIter.advance();
        }
        if (n <= this.settings.lambda) {
            this.mvSize2.put(hashSetModifiableDBIDs.size());
        }
        this.mvCorDim.put(n);
        return new PreDeConNeighborPredicate.PreDeConModel(n, hashSetModifiableDBIDs);
    }

    @Override
    Logging getLogger() {
        return LOG;
    }

    @Override
    public SimpleTypeInformation<?>[] getOutputType() {
        return new SimpleTypeInformation[]{new SimpleTypeInformation<PreDeConNeighborPredicate.PreDeConModel>(PreDeConNeighborPredicate.PreDeConModel.class)};
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        protected FourC.Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.settings = parameterization.tryInstantiate(FourC.Settings.class);
        }

        @Override
        protected FourCNeighborPredicate<O> makeInstance() {
            return new FourCNeighborPredicate(this.settings);
        }
    }

    public static class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<PreDeConNeighborPredicate.PreDeConModel, PreDeConNeighborPredicate.PreDeConModel> {
        public Instance(DBIDs dBIDs, DataStore<PreDeConNeighborPredicate.PreDeConModel> dataStore) {
            super(dBIDs, dataStore);
        }

        @Override
        public PreDeConNeighborPredicate.PreDeConModel getNeighbors(DBIDRef dBIDRef) {
            PreDeConNeighborPredicate.PreDeConModel preDeConModel = (PreDeConNeighborPredicate.PreDeConModel)this.storage.get(dBIDRef);
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(preDeConModel.ids.size());
            DBIDIter dBIDIter = preDeConModel.ids.iter();
            while (dBIDIter.valid()) {
                if (((PreDeConNeighborPredicate.PreDeConModel)this.storage.get((DBIDRef)dBIDIter)).ids.contains(dBIDRef)) {
                    hashSetModifiableDBIDs.add(dBIDIter);
                }
                dBIDIter.advance();
            }
            return new PreDeConNeighborPredicate.PreDeConModel(preDeConModel.pdim, hashSetModifiableDBIDs);
        }

        @Override
        public DBIDIter iterDBIDs(PreDeConNeighborPredicate.PreDeConModel preDeConModel) {
            return preDeConModel.ids.iter();
        }
    }
}

