/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.LinkageMethod;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. H. Ward Jr", title="Hierarchical grouping to optimize an objective function", booktitle="Journal of the American statistical association 58.301", url="http://dx.doi.org/10.1080/01621459.1963.10500845")
@Alias(value={"ward", "variance"})
public class WardLinkageMethod
implements LinkageMethod {
    public static final WardLinkageMethod STATIC = new WardLinkageMethod();

    @Deprecated
    public WardLinkageMethod() {
    }

    @Override
    public double combine(int n, double d, int n2, double d2, int n3, double d3) {
        double d4 = (double)(n + n3) / (double)(n + n2 + n3);
        double d5 = (double)(n2 + n3) / (double)(n + n2 + n3);
        double d6 = (double)n3 / (double)(n + n2 + n3);
        return d4 * d + d5 * d2 - d6 * d3;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WardLinkageMethod makeInstance() {
            return STATIC;
        }
    }
}

