/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.histogram;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="L.N. Vaserstein", title="Markov processes over denumerable products of spaces describing large systems of automata", booktitle="Problemy Peredachi Informatsii 5.3 / Problems of Information Transmission, 5:3", url="http://mi.mathnet.ru/eng/ppi1811")
public class HistogramMatchDistanceFunction
extends AbstractSpatialDistanceFunction {
    public static final HistogramMatchDistanceFunction STATIC = new HistogramMatchDistanceFunction();

    @Deprecated
    public HistogramMatchDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = HistogramMatchDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += Math.abs((d += numberVector.doubleValue(i)) - (d2 += numberVector2.doubleValue(i)));
        }
        return d3;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = HistogramMatchDistanceFunction.dimensionality(spatialComparable, spatialComparable2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d5 += d3 > d2 ? (d3 += spatialComparable2.getMin(i)) - (d2 += spatialComparable.getMax(i)) : (d > d4 ? (d += spatialComparable.getMin(i)) - (d4 += spatialComparable2.getMax(i)) : 0.0);
        }
        return d5;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    public String toString() {
        return "HistogramMatchDistanceFunction";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            return true;
        }
        return super.equals(object);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HistogramMatchDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

