/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseMaximumDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.SparseLPNormDistanceFunction"})
public class SparseLPNormDistanceFunction
extends AbstractPrimitiveDistanceFunction<SparseNumberVector>
implements Norm<SparseNumberVector> {
    private double p;
    private double invp;

    public SparseLPNormDistanceFunction(double d) {
        this.p = d;
        this.invp = 1.0 / d;
    }

    @Override
    public double distance(SparseNumberVector sparseNumberVector, SparseNumberVector sparseNumberVector2) {
        double d = 0.0;
        int n = sparseNumberVector.iter();
        int n2 = sparseNumberVector2.iter();
        while (sparseNumberVector.iterValid(n) && sparseNumberVector2.iterValid(n2)) {
            double d2;
            int n3;
            int n4 = sparseNumberVector.iterDim(n);
            if (n4 < (n3 = sparseNumberVector2.iterDim(n2))) {
                d2 = Math.abs(sparseNumberVector.iterDoubleValue(n));
                d += Math.pow(d2, this.p);
                n = sparseNumberVector.iterAdvance(n);
                continue;
            }
            if (n3 < n4) {
                d2 = Math.abs(sparseNumberVector2.iterDoubleValue(n2));
                d += Math.pow(d2, this.p);
                n2 = sparseNumberVector2.iterAdvance(n2);
                continue;
            }
            d2 = Math.abs(sparseNumberVector.iterDoubleValue(n) - sparseNumberVector2.iterDoubleValue(n2));
            d += Math.pow(d2, this.p);
            n = sparseNumberVector.iterAdvance(n);
            n2 = sparseNumberVector2.iterAdvance(n2);
        }
        while (sparseNumberVector.iterValid(n)) {
            double d3 = Math.abs(sparseNumberVector.iterDoubleValue(n));
            d += Math.pow(d3, this.p);
            n = sparseNumberVector.iterAdvance(n);
        }
        while (sparseNumberVector2.iterValid(n2)) {
            double d4 = Math.abs(sparseNumberVector2.iterDoubleValue(n2));
            d += Math.pow(d4, this.p);
            n2 = sparseNumberVector2.iterAdvance(n2);
        }
        return Math.pow(d, this.invp);
    }

    @Override
    public double norm(SparseNumberVector sparseNumberVector) {
        double d = 0.0;
        int n = sparseNumberVector.iter();
        while (sparseNumberVector.iterValid(n)) {
            double d2 = Math.abs(sparseNumberVector.iterDoubleValue(n));
            d += Math.pow(d2, this.p);
            n = sparseNumberVector.iterAdvance(n);
        }
        return Math.pow(d, this.invp);
    }

    @Override
    public SimpleTypeInformation<? super SparseNumberVector> getInputTypeRestriction() {
        return TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH;
    }

    @Override
    public boolean isMetric() {
        return this.p >= 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        double p = 2.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(LPNormDistanceFunction.Parameterizer.P_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.p = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected SparseLPNormDistanceFunction makeInstance() {
            if (this.p == 2.0) {
                return SparseEuclideanDistanceFunction.STATIC;
            }
            if (this.p == 1.0) {
                return SparseManhattanDistanceFunction.STATIC;
            }
            if (this.p == Double.POSITIVE_INFINITY) {
                return SparseMaximumDistanceFunction.STATIC;
            }
            return new SparseLPNormDistanceFunction(this.p);
        }
    }
}

