/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.index.PagedIndexFactory;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk.BulkSplit;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.CombinedInsertionStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.overflow.LimitedReinsertOverflowTreatment;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.overflow.OverflowTreatment;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.TopologicalSplitter;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractRStarTreeFactory<O extends NumberVector, N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry, I extends AbstractRStarTree<N, E, S>, S extends AbstractRTreeSettings>
extends PagedIndexFactory<O, I> {
    protected S settings;

    public AbstractRStarTreeFactory(PageFileFactory<?> pageFileFactory, S s) {
        super(pageFileFactory);
        this.settings = s;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    public static abstract class Parameterizer<O extends NumberVector, S extends AbstractRTreeSettings>
    extends PagedIndexFactory.Parameterizer<O> {
        public static OptionID INSERTION_STRATEGY_ID = new OptionID("rtree.insertionstrategy", "The strategy to use for object insertion.");
        public static OptionID SPLIT_STRATEGY_ID = new OptionID("rtree.splitstrategy", "The strategy to use for node splitting.");
        public static final OptionID BULK_SPLIT_ID = new OptionID("spatial.bulkstrategy", "The class to perform the bulk split with.");
        public static final OptionID MINIMUM_FILL_ID = new OptionID("rtree.minimum-fill", "Minimum relative fill required for data pages.");
        public static OptionID OVERFLOW_STRATEGY_ID = new OptionID("rtree.overflowtreatment", "The strategy to use for handling overflows.");
        protected S settings;

        protected abstract S createSettings();

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            ObjectParameter objectParameter2;
            super.makeOptions(parameterization);
            this.settings = this.createSettings();
            ObjectParameter objectParameter3 = new ObjectParameter(INSERTION_STRATEGY_ID, (Class<?>)InsertionStrategy.class, CombinedInsertionStrategy.class);
            if (parameterization.grab(objectParameter3)) {
                ((AbstractRTreeSettings)this.settings).insertionStrategy = (InsertionStrategy)objectParameter3.instantiateClass(parameterization);
            }
            if (parameterization.grab(objectParameter2 = new ObjectParameter(SPLIT_STRATEGY_ID, (Class<?>)SplitStrategy.class, TopologicalSplitter.class))) {
                ((AbstractRTreeSettings)this.settings).nodeSplitter = (SplitStrategy)objectParameter2.instantiateClass(parameterization);
            }
            DoubleParameter doubleParameter = new DoubleParameter(MINIMUM_FILL_ID, 0.4);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_HALF_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                ((AbstractRTreeSettings)this.settings).relativeMinFill = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(OVERFLOW_STRATEGY_ID, (Class<?>)OverflowTreatment.class, LimitedReinsertOverflowTreatment.class))) {
                ((AbstractRTreeSettings)this.settings).setOverflowTreatment((OverflowTreatment)objectParameter.instantiateClass(parameterization));
            }
            this.configBulkLoad(parameterization);
        }

        protected void configBulkLoad(Parameterization parameterization) {
            ObjectParameter objectParameter = new ObjectParameter(BULK_SPLIT_ID, BulkSplit.class, true);
            if (parameterization.grab(objectParameter)) {
                ((AbstractRTreeSettings)this.settings).bulkSplitter = (BulkSplit)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected abstract AbstractRStarTreeFactory<O, ?, ?, ?, ?> makeInstance();
    }
}

