/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Alias(value={"InverseGaussianDistribution", "invgauss"})
public class WaldDistribution
extends AbstractDistribution {
    private double mean;
    private double shape;

    public WaldDistribution(double d, double d2, Random random) {
        super(random);
        this.mean = d;
        this.shape = d2;
    }

    public WaldDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        this.mean = d;
        this.shape = d2;
    }

    public WaldDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    @Override
    public double pdf(double d) {
        return WaldDistribution.pdf(d, this.mean, this.shape);
    }

    @Override
    public double cdf(double d) {
        return WaldDistribution.cdf(d, this.mean, this.shape);
    }

    @Override
    @Deprecated
    public double quantile(double d) {
        return WaldDistribution.quantile(d, this.mean, this.shape);
    }

    @Override
    public double nextRandom() {
        double d = this.random.nextGaussian();
        d *= d;
        double d2 = this.mean + this.mean * 0.5 / this.shape * (this.mean * d - Math.sqrt(4.0 * this.mean * this.shape * d + this.mean * this.mean * d * d));
        double d3 = this.random.nextDouble();
        if (d3 * (this.mean + d2) <= this.mean) {
            return d2;
        }
        return this.mean * this.mean / d2;
    }

    @Override
    public String toString() {
        return "WaldDistribution(mean=" + this.mean + ", shape=" + this.shape + ")";
    }

    public static double pdf(double d, double d2, double d3) {
        if (!(d > 0.0)) {
            return 0.0;
        }
        double d4 = d - d2;
        return Math.sqrt(d3 / (Math.PI * 2 * d * d * d)) * Math.exp(-d3 * d4 * d4 / (2.0 * d2 * d2 * d));
    }

    public static double cdf(double d, double d2, double d3) {
        if (!(d > 0.0)) {
            return 0.0;
        }
        double d4 = d / d2;
        double d5 = Math.sqrt(d3 / d);
        double d6 = NormalDistribution.standardNormalCDF(d5 * (d4 - 1.0));
        double d7 = NormalDistribution.standardNormalCDF(-d5 * (d4 + 1.0));
        if (d7 > 0.0) {
            return d6 + Math.exp(2.0 * d3 / d2) * d7;
        }
        return d6;
    }

    @Deprecated
    public static double quantile(double d, double d2, double d3) {
        throw new NotImplementedException("Not yet supported.");
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mean;
        double shape;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.mean = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE_ID))) {
                this.shape = doubleParameter.doubleValue();
            }
        }

        @Override
        protected WaldDistribution makeInstance() {
            return new WaldDistribution(this.mean, this.shape, this.rnd);
        }
    }
}

