/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GeneralizedParetoDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J.R.M. Hosking, J. R. Wallis, and E. F. Wood", title="Estimation of the generalized extreme-value distribution by the method of probability-weighted moments.", booktitle="Technometrics 27.3", url="http://dx.doi.org/10.1080/00401706.1985.10488049")
public class GeneralizedParetoLMMEstimator
extends AbstractLMMEstimator<GeneralizedParetoDistribution> {
    public static final GeneralizedParetoLMMEstimator STATIC = new GeneralizedParetoLMMEstimator();

    private GeneralizedParetoLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public GeneralizedParetoDistribution estimateFromLMoments(double[] dArray) {
        double d = dArray[2];
        if (Math.abs(d) >= 1.0) {
            throw new ArithmeticException("Invalid moment estimation.");
        }
        double d2 = (1.0 - 3.0 * d) / (1.0 + d);
        double d3 = 1.0 / ((1.0 + d2) * (2.0 + d2) + dArray[1]);
        double d4 = dArray[0] - d3 / (1.0 + d2);
        return new GeneralizedParetoDistribution(d4, d3, -d2);
    }

    @Override
    public Class<? super GeneralizedParetoDistribution> getDistributionClass() {
        return GeneralizedParetoDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GeneralizedParetoLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

