/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import java.util.Comparator;

public class OrderingFromDataStore<T extends Comparable<T>>
extends BasicResult
implements OrderingResult {
    protected DataStore<? extends T> map;
    protected DBIDs ids;
    protected Comparator<T> comparator;
    int ascending;

    public OrderingFromDataStore(String string, String string2, DBIDs dBIDs, DataStore<? extends T> dataStore, Comparator<T> comparator, boolean bl) {
        super(string, string2);
        this.map = dataStore;
        this.ids = dBIDs;
        this.comparator = comparator;
        this.ascending = bl ? -1 : 1;
    }

    public OrderingFromDataStore(String string, String string2, DBIDs dBIDs, DataStore<? extends T> dataStore, boolean bl) {
        super(string, string2);
        this.map = dataStore;
        this.ids = dBIDs;
        this.comparator = null;
        this.ascending = bl ? -1 : 1;
    }

    public OrderingFromDataStore(String string, String string2, DBIDs dBIDs, DataStore<? extends T> dataStore) {
        super(string, string2);
        this.map = dataStore;
        this.ids = dBIDs;
        this.comparator = null;
        this.ascending = 1;
    }

    @Override
    public DBIDs getDBIDs() {
        return this.ids;
    }

    @Override
    public ArrayModifiableDBIDs order(DBIDs dBIDs) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
        if (this.comparator != null) {
            arrayModifiableDBIDs.sort(new DerivedComparator());
        } else {
            arrayModifiableDBIDs.sort(new ImpliedComparator());
        }
        return arrayModifiableDBIDs;
    }

    protected final class DerivedComparator
    implements Comparator<DBIDRef> {
        protected DerivedComparator() {
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            Comparable comparable = (Comparable)OrderingFromDataStore.this.map.get(dBIDRef);
            Comparable comparable2 = (Comparable)OrderingFromDataStore.this.map.get(dBIDRef2);
            assert (comparable != null);
            assert (comparable2 != null);
            return OrderingFromDataStore.this.ascending * OrderingFromDataStore.this.comparator.compare(comparable, comparable2);
        }
    }

    protected final class ImpliedComparator
    implements Comparator<DBIDRef> {
        protected ImpliedComparator() {
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            Comparable comparable = (Comparable)OrderingFromDataStore.this.map.get(dBIDRef);
            Comparable comparable2 = (Comparable)OrderingFromDataStore.this.map.get(dBIDRef2);
            assert (comparable != null);
            assert (comparable2 != null);
            return OrderingFromDataStore.this.ascending * comparable.compareTo(comparable2);
        }
    }
}

