/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.thumbs;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThumbnailThread
extends Thread {
    private Queue<Task> queue = new ConcurrentLinkedQueue<Task>();
    private boolean shutdown = false;
    private static ThumbnailThread THREAD = null;

    public static synchronized Task QUEUE(Listener listener) {
        Task task = new Task(listener);
        if (THREAD != null && THREAD.isAlive()) {
            THREAD.queue(task);
            return task;
        }
        THREAD = new ThumbnailThread();
        THREAD.queue(task);
        THREAD.start();
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UNQUEUE(Task task) {
        if (THREAD != null) {
            ThumbnailThread thumbnailThread = THREAD;
            synchronized (thumbnailThread) {
                ThumbnailThread.THREAD.queue.remove(task);
            }
        }
    }

    public static synchronized void SHUTDOWN() {
        if (THREAD != null && THREAD.isAlive()) {
            THREAD.shutdown();
        }
    }

    private void queue(Task task) {
        this.queue.add(task);
    }

    private void generateThumbnail(Task task) {
        task.callback.doThumbnail();
    }

    @Override
    public void run() {
        while (!this.queue.isEmpty() && !this.shutdown) {
            this.generateThumbnail(this.queue.poll());
        }
    }

    private void shutdown() {
        this.shutdown = true;
        this.queue.clear();
    }

    public static interface Listener {
        public void doThumbnail();
    }

    public static class Task {
        Listener callback;

        public Task(Listener listener) {
            this.callback = listener;
        }
    }
}

