/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.epsilon.common.util.OperatingSystem;

public class EmfUtil {
    private static final URI DEFAULT_URI = URI.createFileURI("foo.ecore");

    public static EStructuralFeature getEStructuralFeature(EClass eClass, String featureName) {
        try {
            EClass documentRoot;
            EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
            if (feature == null && (documentRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(eClass.getEPackage())) != null) {
                feature = documentRoot.getEStructuralFeature(featureName);
            }
            return feature;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static URI createPlatformResourceURI(String s) {
        URI uri = EmfUtil.fixUriForOperatingSystem(s, URI.createURI(s));
        if (uri.scheme() == null) {
            return URI.createPlatformResourceURI(s, true);
        }
        return uri;
    }

    public static URI createFileBasedURI(String s) {
        URI uri = EmfUtil.fixUriForOperatingSystem(s, URI.createURI(s));
        if (uri.scheme() == null) {
            return URI.createFileURI(s);
        }
        return uri;
    }

    private static URI fixUriForOperatingSystem(String s, URI uri) {
        if (uri.scheme() != null && OperatingSystem.isWindows() && uri.scheme().length() == 1) {
            return URI.createFileURI(s);
        }
        return uri;
    }

    public static String getFile(URI uri) {
        if (uri.isFile()) {
            return uri.toFileString();
        }
        return uri.toString();
    }

    public static EPackage getTopEPackage(EObject object) {
        return EmfUtil.getTopEPackage(object.eClass().getEPackage());
    }

    public static void collectDependencies(EPackage ePackage, List<EPackage> dependencies) {
        Set<EObject> crossReferencedElements = EcoreUtil.ExternalCrossReferencer.find(ePackage.eResource()).keySet();
        for (Object e : crossReferencedElements) {
            EPackage topEPackage;
            EClassifier eClass;
            EPackage referencedPackage;
            if (!(e instanceof EClassifier) || (referencedPackage = (eClass = (EClassifier)e).getEPackage()) == null || dependencies.contains(topEPackage = EmfUtil.getTopEPackage(referencedPackage))) continue;
            dependencies.add(topEPackage);
            EmfUtil.collectDependencies(topEPackage, dependencies);
        }
    }

    public static EPackage getTopEPackage(EPackage ePackage) {
        EPackage top = ePackage;
        while (top.getESuperPackage() != null) {
            top = top.getESuperPackage();
        }
        return top;
    }

    public static void initialiseResourceFactoryRegistry() {
        Map<String, Object> etfm = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!etfm.containsKey("*")) {
            etfm.put("*", new XMIResourceFactoryImpl());
        }
    }

    public static List<EPackage> register(URI uri, EPackage.Registry registry) throws Exception {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        EmfUtil.initialiseResourceFactoryRegistry();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put(EcorePackage.eINSTANCE.getNsURI(), EcorePackage.eINSTANCE);
        Resource metamodel = resourceSet.createResource(uri);
        metamodel.load(Collections.EMPTY_MAP);
        EmfUtil.setDataTypesInstanceClasses(metamodel);
        TreeIterator<EObject> it = metamodel.getAllContents();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof EPackage)) continue;
            EPackage p = (EPackage)next;
            if (p.getNsURI() == null || p.getNsURI().trim().length() == 0) {
                if (p.getESuperPackage() == null) {
                    p.setNsURI(p.getName());
                } else {
                    p.setNsURI(String.valueOf(p.getESuperPackage().getNsURI()) + "/" + p.getName());
                }
            }
            if ((p.getNsPrefix() == null || p.getNsPrefix().trim().length() == 0) && p.getESuperPackage() != null) {
                if (p.getESuperPackage().getNsPrefix() != null) {
                    p.setNsPrefix(String.valueOf(p.getESuperPackage().getNsPrefix()) + "." + p.getName());
                } else {
                    p.setNsPrefix(p.getName());
                }
            }
            if (p.getNsPrefix() == null) {
                p.setNsPrefix(p.getName());
            }
            registry.put(p.getNsURI(), p);
            metamodel.setURI(URI.createURI(p.getNsURI()));
            ePackages.add(p);
        }
        return ePackages;
    }

    protected static void setDataTypesInstanceClasses(Resource metamodel) {
        TreeIterator<EObject> it = metamodel.getAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (eObject instanceof EEnum || !(eObject instanceof EDataType)) continue;
            EDataType eDataType = (EDataType)eObject;
            String instanceClass = "";
            if (eDataType.getName().equals("String")) {
                instanceClass = "java.lang.String";
            } else if (eDataType.getName().equals("Boolean")) {
                instanceClass = "java.lang.Boolean";
            } else if (eDataType.getName().equals("Integer")) {
                instanceClass = "java.lang.Integer";
            } else if (eDataType.getName().equals("Float")) {
                instanceClass = "java.lang.Float";
            } else if (eDataType.getName().equals("Double")) {
                instanceClass = "java.lang.Double";
            }
            if (instanceClass.trim().length() <= 0) continue;
            eDataType.setInstanceClassName(instanceClass);
        }
    }

    public static List<EClass> getAllEClassesFromSameMetamodelAs(EModelElement metamodelElement) {
        return EmfUtil.getAllModelElementsOfType(metamodelElement, EClass.class);
    }

    public static Collection<EClassifier> getAllEClassifiers(EPackage epackage) {
        ArrayList<EClassifier> allEClassifiers = new ArrayList<EClassifier>();
        allEClassifiers.addAll(epackage.getEClassifiers());
        for (EPackage subpackage : epackage.getESubpackages()) {
            allEClassifiers.addAll(EmfUtil.getAllEClassifiers(subpackage));
        }
        return allEClassifiers;
    }

    public static <T extends EObject> List<T> getAllModelElementsOfType(EObject modelElement, Class<T> type) {
        LinkedList<EObject> results = new LinkedList<EObject>();
        if (modelElement.eResource() != null) {
            TreeIterator<EObject> iterator = modelElement.eResource().getAllContents();
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (!type.isInstance(object)) continue;
                results.add(object);
            }
        }
        return Collections.unmodifiableList(results);
    }

    public static Resource createResource() {
        return EmfUtil.createResource(DEFAULT_URI);
    }

    public static Resource createResource(URI uri) {
        return EmfUtil.createResource(null, uri);
    }

    public static Resource createResource(EObject rootObject) {
        return EmfUtil.createResource(rootObject, DEFAULT_URI);
    }

    public static Resource createResource(EObject rootObject, URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        Resource resource = resourceSet.createResource(uri);
        if (rootObject != null) {
            resource.getContents().add(rootObject);
        }
        return resource;
    }

    public static <T extends EObject> T clone(T object) {
        T cloned = EcoreUtil.copy(object);
        EmfUtil.createResource(cloned);
        return cloned;
    }
}

