/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.postprocessor;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.hutn.model.hutn.AttributeSlot;
import org.eclipse.epsilon.hutn.model.hutn.ClassObject;
import org.eclipse.epsilon.hutn.model.hutn.ReferenceSlot;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.xmi.postprocessor.UriFragmentResolver;
import org.eclipse.epsilon.hutn.xmi.util.EmfUtil;

public class UriFragmentPostProcessor {
    private final Spec spec;
    private final UriFragmentResolver resolver;

    public UriFragmentPostProcessor(Spec spec) {
        this.spec = spec;
        this.resolver = new UriFragmentResolver(spec);
    }

    public void process() {
        this.resolveUriFragmentValuesInReferenceSlots();
        this.resolveUriFragmentValuesInAttributeSlots();
    }

    private void resolveUriFragmentValuesInReferenceSlots() {
        for (ReferenceSlot slot : this.allReferenceSlots()) {
            BasicEList<String> newValues = new BasicEList<String>();
            for (String value : slot.getValues()) {
                newValues.add(this.resolveOrReturn(value));
            }
            slot.setValues(newValues);
        }
    }

    private void resolveUriFragmentValuesInAttributeSlots() {
        for (AttributeSlot slot : this.allAttributeSlots()) {
            BasicEList<Object> newValues = new BasicEList<Object>();
            for (Object value : slot.getValues()) {
                newValues.add(this.resolveOrReturn(value));
            }
            slot.setValues(newValues);
        }
    }

    private List<ReferenceSlot> allReferenceSlots() {
        return EmfUtil.getAllModelElementsOfType(this.spec, ReferenceSlot.class);
    }

    private List<AttributeSlot> allAttributeSlots() {
        return EmfUtil.getAllModelElementsOfType(this.spec, AttributeSlot.class);
    }

    private Object resolveOrReturn(Object potentialUriFragment) {
        if (potentialUriFragment instanceof String) {
            return this.resolveOrReturn((String)potentialUriFragment);
        }
        return potentialUriFragment;
    }

    private String resolveOrReturn(String potentialUriFragment) {
        if (UriFragmentResolver.isUriFragment(potentialUriFragment)) {
            return this.resolveUriFragment(potentialUriFragment);
        }
        return potentialUriFragment;
    }

    private String resolveUriFragment(String uriFragment) {
        StringBuilder identifiersOfResolvedObjects = new StringBuilder();
        for (ClassObject resolvedObject : this.resolver.resolve(uriFragment)) {
            String identifierOfResolvedObject = this.isAnUnknownClassObject(resolvedObject) ? uriFragment : this.determineIdentifier(resolvedObject);
            identifiersOfResolvedObjects.append(identifierOfResolvedObject);
            identifiersOfResolvedObjects.append(' ');
        }
        return identifiersOfResolvedObjects.toString().trim();
    }

    private boolean isAnUnknownClassObject(ClassObject object) {
        return object == null;
    }

    private String determineIdentifier(ClassObject object) {
        if (object.getIdentifier() == null) {
            object.setIdentifier(EcoreUtil.generateUUID());
        }
        return object.getIdentifier();
    }
}

