/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AbstractHDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerDensityHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="HDBSCAN: Hierarchical Density-Based Spatial Clustering of Applications with Noise")
@Description(value="Density-Based Clustering Based on Hierarchical Density Estimates")
@Reference(authors="R. J. G. B. Campello, D. Moulavi, and J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conference on Advances in Knowledge Discovery and Data Mining, PAKDD", url="http://dx.doi.org/10.1007/978-3-642-37456-2_14")
public class SLINKHDBSCANLinearMemory<O>
extends AbstractHDBSCAN<O, PointerDensityHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(SLINKHDBSCANLinearMemory.class);

    public SLINKHDBSCANLinearMemory(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction, n);
    }

    public PointerDensityHierarchyRepresentationResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.minPts);
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        WritableDoubleDataStore writableDoubleDataStore = this.computeCoreDists(arrayDBIDs, kNNQuery, this.minPts);
        WritableDBIDDataStore writableDBIDDataStore = DataStoreUtil.makeDBIDStorage(arrayDBIDs, 6);
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(arrayDBIDs, 6, Double.POSITIVE_INFINITY);
        WritableDoubleDataStore writableDoubleDataStore3 = DataStoreUtil.makeDoubleStorage(arrayDBIDs, 3);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Running HDBSCAN*-SLINK", arrayDBIDs.size(), LOG) : null;
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(arrayDBIDs.size());
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            this.step1(dBIDArrayIter, writableDBIDDataStore, writableDoubleDataStore2);
            this.step2(dBIDArrayIter, arrayModifiableDBIDs, distanceQuery, writableDoubleDataStore, writableDoubleDataStore3);
            this.step3(dBIDArrayIter, writableDBIDDataStore, writableDoubleDataStore2, arrayModifiableDBIDs, writableDoubleDataStore3);
            this.step4(dBIDArrayIter, writableDBIDDataStore, writableDoubleDataStore2, arrayModifiableDBIDs);
            arrayModifiableDBIDs.add(dBIDArrayIter);
            LOG.incrementProcessed(finiteProgress);
            dBIDArrayIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        return new PointerDensityHierarchyRepresentationResult(arrayDBIDs, writableDBIDDataStore, writableDoubleDataStore2, writableDoubleDataStore);
    }

    private void step1(DBIDRef dBIDRef, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore) {
        writableDBIDDataStore.put(dBIDRef, dBIDRef);
    }

    private void step2(DBIDRef dBIDRef, DBIDs dBIDs, DistanceQuery<? super O> distanceQuery, DoubleDataStore doubleDataStore, WritableDoubleDataStore writableDoubleDataStore) {
        double d = doubleDataStore.doubleValue(dBIDRef);
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d2 = doubleDataStore.doubleValue(dBIDIter);
            double d3 = MathUtil.max(d, d2, distanceQuery.distance(dBIDRef, (DBIDRef)dBIDIter));
            writableDoubleDataStore.putDouble(dBIDIter, d3);
            dBIDIter.advance();
        }
    }

    private void step3(DBIDRef dBIDRef, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore, DBIDs dBIDs, WritableDoubleDataStore writableDoubleDataStore2) {
        DBIDVar dBIDVar = DBIDUtil.newVar();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d = writableDoubleDataStore.doubleValue(dBIDIter);
            double d2 = writableDoubleDataStore2.doubleValue(dBIDIter);
            writableDBIDDataStore.assignVar(dBIDIter, dBIDVar);
            double d3 = writableDoubleDataStore2.doubleValue(dBIDVar);
            if (d >= d2) {
                if (d < d3) {
                    writableDoubleDataStore2.putDouble(dBIDVar, d);
                }
                writableDoubleDataStore.putDouble(dBIDIter, d2);
                writableDBIDDataStore.put((DBIDRef)dBIDIter, dBIDRef);
            } else if (d2 < d3) {
                writableDoubleDataStore2.putDouble(dBIDVar, d2);
            }
            dBIDIter.advance();
        }
    }

    private void step4(DBIDRef dBIDRef, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore, DBIDs dBIDs) {
        DBIDVar dBIDVar = DBIDUtil.newVar();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d = writableDoubleDataStore.doubleValue(dBIDIter);
            writableDBIDDataStore.assignVar(dBIDIter, dBIDVar);
            double d2 = writableDoubleDataStore.doubleValue(dBIDVar);
            if (d >= d2) {
                writableDBIDDataStore.put((DBIDRef)dBIDIter, dBIDRef);
            }
            dBIDIter.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractHDBSCAN.Parameterizer<O> {
        @Override
        protected SLINKHDBSCANLinearMemory<O> makeInstance() {
            return new SLINKHDBSCANLinearMemory(this.distanceFunction, this.minPts);
        }
    }
}

