/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="V. Hautam\u00e4ki and I. K\u00e4rkk\u00e4inen and P. Fr\u00e4nti", title="Outlier detection using k-nearest neighbour graph", booktitle="Proc. 17th Int. Conf. Pattern Recognition, ICPR 2004", url="http://dx.doi.org/10.1109/ICPR.2004.1334558")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.ODIN"})
public class ODIN<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ODIN.class);
    int k;

    public ODIN(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.k = n + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k);
        DBIDs dBIDs = relation.getDBIDs();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 30, 0.0);
        double d = 1.0 / (double)(this.k - 1);
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = 0.0;
        Object object2 = dBIDs.iter();
        while (object2.valid()) {
            object = kNNQuery.getKNNForDBID((DBIDRef)object2, this.k);
            DBIDIter dBIDIter = object.iter();
            while (dBIDIter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object2, dBIDIter)) {
                    double d4 = writableDoubleDataStore.doubleValue(dBIDIter) + d;
                    if (d4 < d2) {
                        d2 = d4;
                    }
                    if (d4 > d3) {
                        d3 = d4;
                    }
                    writableDoubleDataStore.put((DBIDRef)dBIDIter, d4);
                }
                dBIDIter.advance();
            }
            object2.advance();
        }
        object2 = new InvertedOutlierScoreMeta(d2, d3, 0.0, d * (double)(dBIDs.size() - 1), 1.0);
        object = new MaterializedDoubleRelation("ODIN In-Degree", "odin", writableDoubleDataStore, dBIDs);
        return new OutlierResult((OutlierScoreMeta)object2, (DoubleRelation)object);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("odin.k", "Number of neighbors to use for kNN graph.");
        int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
        }

        @Override
        protected ODIN<O> makeInstance() {
            return new ODIN(this.distanceFunction, this.k);
        }
    }
}

