/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDKNNList;

class DoubleIntegerDBIDPairKNNListHeap
implements IntegerDBIDKNNList,
KNNHeap {
    private final int k;
    private DoubleIntegerDBIDPair[] data;
    private int size;

    protected DoubleIntegerDBIDPairKNNListHeap(int n) {
        this.data = new DoubleIntegerDBIDPair[n + 5];
        this.k = n;
        this.size = 0;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
    }

    @Override
    public double insert(double d, DBIDRef dBIDRef) {
        int n = this.k - 1;
        if (this.size < this.k || d <= this.data[n].doubleValue()) {
            if (this.size > this.data.length) {
                this.grow();
            }
            this.insertionSort(new DoubleIntegerDBIDPair(d, dBIDRef.internalGetIndex()));
            if (this.size > this.k && this.data[this.k].doubleValue() > this.data[n].doubleValue()) {
                this.truncate();
            }
        }
        return this.size < this.k ? Double.POSITIVE_INFINITY : this.get(n).doubleValue();
    }

    private void truncate() {
        for (int i = this.k; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = this.k;
    }

    @Override
    public void insert(DoubleDBIDPair doubleDBIDPair) {
        int n = this.k - 1;
        double d = doubleDBIDPair.doubleValue();
        if (this.size < this.k || d <= this.data[n].doubleValue()) {
            if (this.size > this.data.length) {
                this.grow();
            }
            if (doubleDBIDPair instanceof DoubleIntegerDBIDPair) {
                this.insertionSort((DoubleIntegerDBIDPair)doubleDBIDPair);
            } else {
                this.insertionSort(new DoubleIntegerDBIDPair(d, doubleDBIDPair.internalGetIndex()));
            }
            if (this.size > this.k && this.data[this.k].doubleValue() > this.data[n].doubleValue()) {
                this.truncate();
            }
        }
    }

    private void insertionSort(DoubleIntegerDBIDPair doubleIntegerDBIDPair) {
        int n;
        DoubleIntegerDBIDPair doubleIntegerDBIDPair2;
        int n2 = this.size;
        while (n2 > 0 && !((doubleIntegerDBIDPair2 = this.data[n = n2 - 1]).doubleValue() <= doubleIntegerDBIDPair.doubleValue())) {
            this.data[n2] = doubleIntegerDBIDPair2;
            n2 = n;
        }
        this.data[n2] = doubleIntegerDBIDPair;
        ++this.size;
    }

    private void grow() {
        DoubleIntegerDBIDPair[] doubleIntegerDBIDPairArray = this.data;
        this.data = new DoubleIntegerDBIDPair[this.data.length + (this.data.length >> 1)];
        System.arraycopy(doubleIntegerDBIDPairArray, 0, this.data, 0, doubleIntegerDBIDPairArray.length);
    }

    @Override
    public DoubleIntegerDBIDPair poll() {
        assert (this.size > 0);
        return this.data[this.size--];
    }

    @Override
    public DoubleIntegerDBIDPair peek() {
        assert (this.size > 0);
        return this.data[this.size - 1];
    }

    @Override
    public KNNList toKNNList() {
        return this;
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public double getKNNDistance() {
        return this.size >= this.k ? this.get(this.k - 1).doubleValue() : Double.POSITIVE_INFINITY;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("kNNList[");
        Itr itr = this.iter();
        while (itr.valid()) {
            stringBuilder.append(itr.doubleValue()).append(':').append(DBIDUtil.toString(itr));
            itr.advance();
            if (!itr.valid()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public DoubleIntegerDBIDPair get(int n) {
        return this.data[n];
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        Itr itr = this.iter();
        while (itr.valid()) {
            if (DBIDUtil.equal(itr, dBIDRef)) {
                return true;
            }
            itr.advance();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private class Itr
    implements DoubleIntegerDBIDListIter,
    IntegerDBIDArrayIter {
        private int pos = 0;

        private Itr() {
        }

        @Override
        public int internalGetIndex() {
            return DoubleIntegerDBIDPairKNNListHeap.this.get(this.pos).internalGetIndex();
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleIntegerDBIDPairKNNListHeap.this.size && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public double doubleValue() {
            return DoubleIntegerDBIDPairKNNListHeap.this.get(this.pos).doubleValue();
        }

        @Override
        public DoubleIntegerDBIDPair getPair() {
            return DoubleIntegerDBIDPairKNNListHeap.this.get(this.pos);
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public Itr advance(int n) {
            this.pos += n;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }
    }
}

