/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores;

import de.lmu.ifi.dbs.elki.evaluation.scores.AbstractScoreEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class PrecisionAtKEvaluation
extends AbstractScoreEvaluation {
    public static final PrecisionAtKEvaluation RPRECISION = new PrecisionAtKEvaluation(0);
    int k;

    public PrecisionAtKEvaluation(int n) {
        this.k = n;
    }

    @Override
    public <I extends ScoreEvaluation.ScoreIter> double evaluate(ScoreEvaluation.Predicate<? super I> predicate, I i) {
        int n;
        int n2;
        int n3 = this.k > 0 ? this.k : predicate.numPositive();
        double d = 0.0;
        for (n = 0; i.valid() && n < n3; n += n2) {
            int n4 = 0;
            n2 = 0;
            do {
                if (predicate.test(i)) {
                    ++n4;
                }
                ++n2;
                i.advance();
            } while (i.valid() && i.tiedToPrevious());
            if (n + n2 > n3) {
                d += (double)n4 / (double)n2 * (double)(n3 - n);
                n = n3;
                break;
            }
            d += (double)n4;
        }
        return d / (double)n;
    }

    @Override
    public double expected(int n, int n2) {
        return (double)n / (double)n2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID K_ID = new OptionID("precision.k", "k value for precision@k. Can be set to 0, to get R-precision, or the precision-recall-break-even-point.");
        int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)((IntParameter)new IntParameter(K_ID).setDefaultValue((Object)0)).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
        }

        @Override
        protected PrecisionAtKEvaluation makeInstance() {
            return this.k > 0 ? new PrecisionAtKEvaluation(this.k) : RPRECISION;
        }
    }
}

