/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenvalueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class SortedEigenPairs {
    private EigenPair[] eigenPairs;

    private SortedEigenPairs() {
    }

    public SortedEigenPairs(EigenvalueDecomposition eigenvalueDecomposition, final boolean bl) {
        double[] dArray = eigenvalueDecomposition.getRealEigenvalues();
        Matrix matrix = eigenvalueDecomposition.getV();
        this.eigenPairs = new EigenPair[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d = Math.abs(dArray[i]);
            Vector vector = matrix.getCol(i);
            this.eigenPairs[i] = new EigenPair(vector, d);
        }
        Comparator<EigenPair> comparator = new Comparator<EigenPair>(){

            @Override
            public int compare(EigenPair eigenPair, EigenPair eigenPair2) {
                int n = eigenPair.compareTo(eigenPair2);
                if (!bl) {
                    n = -1 * n;
                }
                return n;
            }
        };
        Arrays.sort(this.eigenPairs, comparator);
    }

    public SortedEigenPairs(List<EigenPair> list) {
        Comparator<EigenPair> comparator = new Comparator<EigenPair>(){

            @Override
            public int compare(EigenPair eigenPair, EigenPair eigenPair2) {
                return -1 * eigenPair.compareTo(eigenPair2);
            }
        };
        this.eigenPairs = list.toArray(new EigenPair[list.size()]);
        Arrays.sort(this.eigenPairs, comparator);
    }

    public double[] eigenValues() {
        double[] dArray = new double[this.eigenPairs.length];
        for (int i = 0; i < this.eigenPairs.length; ++i) {
            EigenPair eigenPair = this.eigenPairs[i];
            dArray[i] = eigenPair.getEigenvalue();
        }
        return dArray;
    }

    public Matrix eigenVectors() {
        Matrix matrix = new Matrix(this.eigenPairs.length, this.eigenPairs.length);
        for (int i = 0; i < this.eigenPairs.length; ++i) {
            EigenPair eigenPair = this.eigenPairs[i];
            matrix.setCol(i, eigenPair.getEigenvector());
        }
        return matrix;
    }

    public Matrix eigenVectors(int n) {
        Matrix matrix = new Matrix(this.eigenPairs.length, n);
        for (int i = 0; i < n; ++i) {
            EigenPair eigenPair = this.eigenPairs[i];
            matrix.setCol(i, eigenPair.getEigenvector());
        }
        return matrix;
    }

    public Matrix reverseEigenVectors(int n) {
        Matrix matrix = new Matrix(this.eigenPairs.length, n);
        for (int i = 0; i < n; ++i) {
            EigenPair eigenPair = this.eigenPairs[this.eigenPairs.length - 1 - i];
            matrix.setCol(i, eigenPair.getEigenvector());
        }
        return matrix;
    }

    public EigenPair getEigenPair(int n) {
        return this.eigenPairs[n];
    }

    public int size() {
        return this.eigenPairs.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (EigenPair eigenPair : this.eigenPairs) {
            stringBuilder.append('\n').append(eigenPair);
        }
        return stringBuilder.toString();
    }

    public SortedEigenPairs copy() {
        SortedEigenPairs sortedEigenPairs = new SortedEigenPairs();
        sortedEigenPairs.eigenPairs = (EigenPair[])this.eigenPairs.clone();
        return sortedEigenPairs;
    }
}

