/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.persistent.AbstractPageFileFactory;
import de.lmu.ifi.dbs.elki.persistent.ExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PersistentPageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;

public class PersistentPageFileFactory<P extends ExternalizablePage>
extends AbstractPageFileFactory<P> {
    private String fileName;

    public PersistentPageFileFactory(int n, String string) {
        super(n);
        this.fileName = string;
    }

    @Override
    public PageFile<P> newPageFile(Class<P> clazz) {
        if (this.fileName == null) {
            throw new AbortException("Disk-backed page file may only be instantiated once!");
        }
        PersistentPageFile<P> persistentPageFile = new PersistentPageFile<P>(this.pageSize, this.fileName, clazz);
        this.fileName = null;
        return persistentPageFile;
    }

    public static class Parameterizer
    extends AbstractPageFileFactory.Parameterizer<ExternalizablePage> {
        private String fileName;
        public static final OptionID FILE_ID = new OptionID("pagefile.file", "The name of the file storing the page file.");

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(FILE_ID, FileParameter.FileType.OUTPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.fileName = ((File)fileParameter.getValue()).getPath();
            }
        }

        @Override
        protected PersistentPageFileFactory<ExternalizablePage> makeInstance() {
            return new PersistentPageFileFactory<ExternalizablePage>(this.pageSize, this.fileName);
        }
    }
}

