/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import weka.associations.ItemSet;
import weka.core.ContingencyTables;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.WekaEnumeration;

public class AprioriItemSet
extends ItemSet
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = 7684467755712672058L;

    public AprioriItemSet(int totalTrans) {
        super(totalTrans);
    }

    public static double confidenceForRule(AprioriItemSet premise, AprioriItemSet consequence) {
        return (double)consequence.m_counter / (double)premise.m_counter;
    }

    public double liftForRule(AprioriItemSet premise, AprioriItemSet consequence, int consequenceCount) {
        double confidence = AprioriItemSet.confidenceForRule(premise, consequence);
        return confidence / ((double)consequenceCount / (double)this.m_totalTransactions);
    }

    public double leverageForRule(AprioriItemSet premise, AprioriItemSet consequence, int premiseCount, int consequenceCount) {
        double coverageForItemSet = (double)consequence.m_counter / (double)this.m_totalTransactions;
        double expectedCoverageIfIndependent = (double)premiseCount / (double)this.m_totalTransactions * ((double)consequenceCount / (double)this.m_totalTransactions);
        double lev = coverageForItemSet - expectedCoverageIfIndependent;
        return lev;
    }

    public double convictionForRule(AprioriItemSet premise, AprioriItemSet consequence, int premiseCount, int consequenceCount) {
        double num = (double)premiseCount * (double)(this.m_totalTransactions - consequenceCount) / (double)this.m_totalTransactions;
        double denom = premiseCount - consequence.m_counter + 1;
        if (num < 0.0 || denom < 0.0) {
            System.err.println("*** " + num + " " + denom);
            System.err.println("premis count: " + premiseCount + " consequence count " + consequenceCount + " total trans " + this.m_totalTransactions);
        }
        return num / denom;
    }

    public ArrayList<Object>[] generateRules(double minConfidence, ArrayList<Hashtable<ItemSet, Integer>> hashtables, int numItemsInSet) {
        ArrayList<AprioriItemSet> premises = new ArrayList<AprioriItemSet>();
        ArrayList<AprioriItemSet> consequences = new ArrayList<AprioriItemSet>();
        ArrayList<Double> conf = new ArrayList<Double>();
        ArrayList<Double> lift = new ArrayList<Double>();
        ArrayList<Double> lev = new ArrayList<Double>();
        ArrayList<Double> conv = new ArrayList<Double>();
        ArrayList[] rules = new ArrayList[6];
        Hashtable<ItemSet, Integer> hashtable = hashtables.get(numItemsInSet - 2);
        int i = 0;
        while (i < this.m_items.length) {
            if (this.m_items[i] != -1) {
                AprioriItemSet premise = new AprioriItemSet(this.m_totalTransactions);
                AprioriItemSet consequence = new AprioriItemSet(this.m_totalTransactions);
                premise.m_items = new int[this.m_items.length];
                consequence.m_items = new int[this.m_items.length];
                consequence.m_counter = this.m_counter;
                int j = 0;
                while (j < this.m_items.length) {
                    consequence.m_items[j] = -1;
                    ++j;
                }
                System.arraycopy(this.m_items, 0, premise.m_items, 0, this.m_items.length);
                premise.m_items[i] = -1;
                consequence.m_items[i] = this.m_items[i];
                premise.m_counter = hashtable.get(premise);
                Hashtable<ItemSet, Integer> hashtableForConsequence = hashtables.get(0);
                int consequenceUnconditionedCounter = hashtableForConsequence.get(consequence);
                premises.add(premise);
                consequences.add(consequence);
                conf.add(new Double(AprioriItemSet.confidenceForRule(premise, consequence)));
                double tempLift = this.liftForRule(premise, consequence, consequenceUnconditionedCounter);
                double tempLev = this.leverageForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter);
                double tempConv = this.convictionForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter);
                lift.add(new Double(tempLift));
                lev.add(new Double(tempLev));
                conv.add(new Double(tempConv));
            }
            ++i;
        }
        rules[0] = premises;
        rules[1] = consequences;
        rules[2] = conf;
        rules[3] = lift;
        rules[4] = lev;
        rules[5] = conv;
        AprioriItemSet.pruneRules(rules, minConfidence);
        ArrayList<Object>[] moreResults = this.moreComplexRules(rules, numItemsInSet, 1, minConfidence, hashtables);
        if (moreResults != null) {
            i = 0;
            while (i < moreResults[0].size()) {
                rules[0].add(moreResults[0].get(i));
                rules[1].add(moreResults[1].get(i));
                rules[2].add(moreResults[2].get(i));
                rules[3].add(moreResults[3].get(i));
                rules[4].add(moreResults[4].get(i));
                rules[5].add(moreResults[5].get(i));
                ++i;
            }
        }
        return rules;
    }

    public final ArrayList<Object>[] generateRulesBruteForce(double minMetric, int metricType, ArrayList<Hashtable<ItemSet, Integer>> hashtables, int numItemsInSet, int numTransactions, double significanceLevel) throws Exception {
        ArrayList<AprioriItemSet> premises = new ArrayList<AprioriItemSet>();
        ArrayList<AprioriItemSet> consequences = new ArrayList<AprioriItemSet>();
        ArrayList<Double> conf = new ArrayList<Double>();
        ArrayList<Double> lift = new ArrayList<Double>();
        ArrayList<Double> lev = new ArrayList<Double>();
        ArrayList<Double> conv = new ArrayList<Double>();
        ArrayList[] rules = new ArrayList[6];
        double[][] contingencyTable = new double[2][2];
        double chiSquared = 0.0;
        int max = (int)Math.pow(2.0, numItemsInSet);
        int j = 1;
        while (j < max) {
            int numItemsInPremise = 0;
            int help = j;
            while (help > 0) {
                if (help % 2 == 1) {
                    ++numItemsInPremise;
                }
                help /= 2;
            }
            if (numItemsInPremise < numItemsInSet) {
                double metric;
                Hashtable<ItemSet, Integer> hashtableForPremise = hashtables.get(numItemsInPremise - 1);
                Hashtable<ItemSet, Integer> hashtableForConsequence = hashtables.get(numItemsInSet - numItemsInPremise - 1);
                AprioriItemSet premise = new AprioriItemSet(this.m_totalTransactions);
                AprioriItemSet consequence = new AprioriItemSet(this.m_totalTransactions);
                premise.m_items = new int[this.m_items.length];
                consequence.m_items = new int[this.m_items.length];
                consequence.m_counter = this.m_counter;
                help = j;
                int i = 0;
                while (i < this.m_items.length) {
                    if (this.m_items[i] != -1) {
                        if (help % 2 == 1) {
                            premise.m_items[i] = this.m_items[i];
                            consequence.m_items[i] = -1;
                        } else {
                            premise.m_items[i] = -1;
                            consequence.m_items[i] = this.m_items[i];
                        }
                        help /= 2;
                    } else {
                        premise.m_items[i] = -1;
                        consequence.m_items[i] = -1;
                    }
                    ++i;
                }
                premise.m_counter = hashtableForPremise.get(premise);
                int consequenceUnconditionedCounter = hashtableForConsequence.get(consequence);
                if (significanceLevel != -1.0) {
                    contingencyTable[0][0] = consequence.m_counter;
                    contingencyTable[0][1] = premise.m_counter - consequence.m_counter;
                    contingencyTable[1][0] = consequenceUnconditionedCounter - consequence.m_counter;
                    contingencyTable[1][1] = numTransactions - premise.m_counter - consequenceUnconditionedCounter + consequence.m_counter;
                    chiSquared = ContingencyTables.chiSquared(contingencyTable, false);
                }
                if (metricType == 0) {
                    metric = AprioriItemSet.confidenceForRule(premise, consequence);
                    if (!(metric < minMetric || significanceLevel != -1.0 && chiSquared > significanceLevel)) {
                        premises.add(premise);
                        consequences.add(consequence);
                        conf.add(new Double(metric));
                        lift.add(new Double(this.liftForRule(premise, consequence, consequenceUnconditionedCounter)));
                        lev.add(new Double(this.leverageForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter)));
                        conv.add(new Double(this.convictionForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter)));
                    }
                } else {
                    double tempConf = AprioriItemSet.confidenceForRule(premise, consequence);
                    double tempLift = this.liftForRule(premise, consequence, consequenceUnconditionedCounter);
                    double tempLev = this.leverageForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter);
                    double tempConv = this.convictionForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter);
                    switch (metricType) {
                        case 1: {
                            metric = tempLift;
                            break;
                        }
                        case 2: {
                            metric = tempLev;
                            break;
                        }
                        case 3: {
                            metric = tempConv;
                            break;
                        }
                        default: {
                            throw new Exception("ItemSet: Unknown metric type!");
                        }
                    }
                    if (!(metric < minMetric || significanceLevel != -1.0 && chiSquared > significanceLevel)) {
                        premises.add(premise);
                        consequences.add(consequence);
                        conf.add(new Double(tempConf));
                        lift.add(new Double(tempLift));
                        lev.add(new Double(tempLev));
                        conv.add(new Double(tempConv));
                    }
                }
            }
            ++j;
        }
        rules[0] = premises;
        rules[1] = consequences;
        rules[2] = conf;
        rules[3] = lift;
        rules[4] = lev;
        rules[5] = conv;
        return rules;
    }

    public final AprioriItemSet subtract(AprioriItemSet toSubtract) {
        AprioriItemSet result = new AprioriItemSet(this.m_totalTransactions);
        result.m_items = new int[this.m_items.length];
        int i = 0;
        while (i < this.m_items.length) {
            result.m_items[i] = toSubtract.m_items[i] == -1 ? this.m_items[i] : -1;
            ++i;
        }
        result.m_counter = 0;
        return result;
    }

    private final ArrayList<Object>[] moreComplexRules(ArrayList<Object>[] rules, int numItemsInSet, int numItemsInConsequence, double minConfidence, ArrayList<Hashtable<ItemSet, Integer>> hashtables) {
        ArrayList<AprioriItemSet> newPremises = new ArrayList<AprioriItemSet>();
        ArrayList<Double> newConf = new ArrayList<Double>();
        ArrayList<Double> newLift = null;
        ArrayList<Double> newLev = null;
        ArrayList<Double> newConv = null;
        newLift = new ArrayList<Double>();
        newLev = new ArrayList<Double>();
        newConv = new ArrayList<Double>();
        if (numItemsInSet > numItemsInConsequence + 1) {
            Hashtable<ItemSet, Integer> hashtable = hashtables.get(numItemsInSet - numItemsInConsequence - 2);
            ArrayList<Object> newConsequences = AprioriItemSet.mergeAllItemSets(rules[1], numItemsInConsequence - 1, this.m_totalTransactions);
            int newNumInConsequence = numItemsInConsequence + 1;
            Hashtable<ItemSet, Integer> hashtableForConsequence = hashtables.get(newNumInConsequence - 1);
            WekaEnumeration<Object> enu = new WekaEnumeration<Object>(newConsequences);
            while (enu.hasMoreElements()) {
                AprioriItemSet current = (AprioriItemSet)enu.nextElement();
                int[] nArray = current.m_items;
                int n = current.m_items.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    ++n2;
                }
                current.m_counter = this.m_counter;
                AprioriItemSet newPremise = this.subtract(current);
                newPremise.m_counter = hashtable.get(newPremise);
                newPremises.add(newPremise);
                newConf.add(new Double(AprioriItemSet.confidenceForRule(newPremise, current)));
                int consequenceUnconditionedCounter = hashtableForConsequence.get(current);
                double tempLift = this.liftForRule(newPremise, current, consequenceUnconditionedCounter);
                double tempLev = this.leverageForRule(newPremise, current, newPremise.m_counter, consequenceUnconditionedCounter);
                double tempConv = this.convictionForRule(newPremise, current, newPremise.m_counter, consequenceUnconditionedCounter);
                newLift.add(new Double(tempLift));
                newLev.add(new Double(tempLev));
                newConv.add(new Double(tempConv));
            }
            ArrayList[] result = new ArrayList[rules.length];
            result[0] = newPremises;
            result[1] = newConsequences;
            result[2] = newConf;
            result[3] = newLift;
            result[4] = newLev;
            result[5] = newConv;
            AprioriItemSet.pruneRules(result, minConfidence);
            ArrayList<Object>[] moreResults = this.moreComplexRules(result, numItemsInSet, numItemsInConsequence + 1, minConfidence, hashtables);
            if (moreResults != null) {
                int i = 0;
                while (i < moreResults[0].size()) {
                    result[0].add(moreResults[0].get(i));
                    result[1].add(moreResults[1].get(i));
                    result[2].add(moreResults[2].get(i));
                    result[3].add(moreResults[3].get(i));
                    result[4].add(moreResults[4].get(i));
                    result[5].add(moreResults[5].get(i));
                    ++i;
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public final String toString(Instances instances) {
        return super.toString(instances);
    }

    public static ArrayList<Object> singletons(Instances instances, boolean treatZeroAsMissing) throws Exception {
        ArrayList<Object> setOfItemSets = new ArrayList<Object>();
        int i = 0;
        while (i < instances.numAttributes()) {
            if (instances.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            int j = treatZeroAsMissing ? 1 : 0;
            while (j < instances.attribute(i).numValues()) {
                AprioriItemSet current = new AprioriItemSet(instances.numInstances());
                current.m_items = new int[instances.numAttributes()];
                int k = 0;
                while (k < instances.numAttributes()) {
                    current.m_items[k] = -1;
                    ++k;
                }
                current.m_items[i] = j++;
                setOfItemSets.add(current);
            }
            ++i;
        }
        return setOfItemSets;
    }

    public static ArrayList<Object> mergeAllItemSets(ArrayList<Object> itemSets, int size, int totalTrans) {
        ArrayList<Object> newVector = new ArrayList<Object>();
        int i = 0;
        while (i < itemSets.size()) {
            ItemSet first = (ItemSet)itemSets.get(i);
            int j = i + 1;
            block1: while (j < itemSets.size()) {
                ItemSet second = (ItemSet)itemSets.get(j);
                AprioriItemSet result = new AprioriItemSet(totalTrans);
                result.m_items = new int[first.m_items.length];
                int numFound = 0;
                int k = 0;
                while (numFound < size) {
                    if (first.m_items[k] != second.m_items[k]) break block1;
                    if (first.m_items[k] != -1) {
                        ++numFound;
                    }
                    result.m_items[k] = first.m_items[k];
                    ++k;
                }
                while (k < first.m_items.length) {
                    if (first.m_items[k] != -1 && second.m_items[k] != -1) break;
                    result.m_items[k] = first.m_items[k] != -1 ? first.m_items[k] : second.m_items[k];
                    ++k;
                }
                if (k == first.m_items.length) {
                    result.m_counter = 0;
                    newVector.add(result);
                }
                ++j;
            }
            ++i;
        }
        return newVector;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

