/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.ELKILogRecord;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class LoggingUtil {
    public static final void logExpensive(Level level, String string, Throwable throwable) {
        String[] stringArray = LoggingUtil.inferCaller();
        if (stringArray != null) {
            Logger logger = Logger.getLogger(stringArray[0]);
            logger.logp(level, stringArray[0], stringArray[1], string, throwable);
        } else {
            Logger.getAnonymousLogger().log(level, string, throwable);
        }
    }

    public static final void logExpensive(Level level, String string) {
        ELKILogRecord eLKILogRecord = new ELKILogRecord(level, (CharSequence)string);
        String[] stringArray = LoggingUtil.inferCaller();
        if (stringArray != null) {
            ((LogRecord)eLKILogRecord).setSourceClassName(stringArray[0]);
            ((LogRecord)eLKILogRecord).setSourceMethodName(stringArray[1]);
            Logger logger = Logger.getLogger(stringArray[0]);
            logger.log(eLKILogRecord);
        } else {
            Logger.getAnonymousLogger().log(eLKILogRecord);
        }
    }

    public static final void exception(Throwable throwable) {
        LoggingUtil.logExpensive(Level.SEVERE, throwable.getMessage(), throwable);
    }

    public static final void exception(String string, Throwable throwable) {
        if (string == null && throwable != null) {
            string = throwable.getMessage();
        }
        LoggingUtil.logExpensive(Level.SEVERE, string, throwable);
    }

    public static final void warning(String string) {
        LoggingUtil.logExpensive(Level.WARNING, string);
    }

    public static final void warning(String string, Throwable throwable) {
        if (string == null && throwable != null) {
            string = throwable.getMessage();
        }
        LoggingUtil.logExpensive(Level.WARNING, string, throwable);
    }

    public static final void message(String string) {
        LoggingUtil.logExpensive(Level.INFO, string);
    }

    public static final void message(String string, Throwable throwable) {
        if (string == null && throwable != null) {
            string = throwable.getMessage();
        }
        LoggingUtil.logExpensive(Level.INFO, string, throwable);
    }

    private static final String[] inferCaller() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (stackTraceElement.getClassName().equals(LoggingUtil.class.getCanonicalName())) continue;
            return new String[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName()};
        }
        return null;
    }
}

