/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf.util;

import java.util.Arrays;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public abstract class EListUtil {
    private EListUtil() {
    }

    public static <T> EList<T> asEList(T ... array) {
        BasicEList<T> list = new BasicEList<T>();
        list.addAll(Arrays.asList(array));
        return list;
    }

    public static <T> EList<T> singletonEList(T original) {
        BasicEList<T> list = new BasicEList<T>();
        list.add(original);
        return list;
    }

    public static boolean elementsAreAllOfSameType(EList<?> list) {
        if (!list.isEmpty()) {
            if (list.get(0) != null) {
                return EListUtil.elementsAreAllInstancesOf(list, list.get(0).getClass());
            }
            return EListUtil.elementsAreAllNull(list);
        }
        return true;
    }

    private static boolean elementsAreAllNull(EList<?> list) {
        for (Object element : list) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    public static boolean elementsAreAllInstancesOf(EList<?> list, Class<?> type) {
        for (Object element : list) {
            if (type.isInstance(element)) continue;
            return false;
        }
        return true;
    }

    public static <T> EList<T> castElements(EList<?> list, Class<? extends T> type) {
        BasicEList<T> results = new BasicEList<T>();
        for (Object element : list) {
            results.add(type.cast(element));
        }
        return results;
    }
}

