/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.UriUtil;
import org.eclipse.epsilon.eol.IEolLibraryModule;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EolImport
extends AbstractModuleElement {
    private IEolLibraryModule parentModule;
    private IModule importedModule;
    private boolean loaded = false;
    private boolean found = false;

    public EolImport(AST ast, IEolLibraryModule parentModule, IModule importedModule) {
        this.setAst(ast);
        this.parentModule = parentModule;
        this.importedModule = importedModule;
    }

    public void load(URI baseUri) {
        try {
            URI uri;
            File file = new File(this.getPath());
            if (file.isAbsolute()) {
                if (!file.exists()) {
                    return;
                }
                uri = file.toURI();
            } else {
                uri = UriUtil.resolve(this.getPath(), baseUri);
            }
            IEolLibraryModule ancestor = this.parentModule;
            while (ancestor != null && !this.found) {
                if (ancestor.getSourceUri() != null && ancestor.getSourceUri().equals(uri)) {
                    this.found = true;
                    this.importedModule = ancestor;
                }
                ancestor = ancestor.getParentModule();
            }
            if (!this.found) {
                try {
                    this.importedModule.parse(uri);
                }
                catch (Exception e) {
                    if ("platform".equals(uri.getScheme()) && uri.getPath().startsWith("/plugin/")) {
                        String sNewURI = uri.toString().replaceFirst("/plugin/", "/resource/");
                        uri = new URI(sNewURI);
                        this.importedModule.parse(uri);
                    }
                    throw e;
                }
            }
            this.found = true;
            if (this.importedModule.getParseProblems().size() == 0) {
                this.loaded = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<?> getChildren() {
        if (!this.loaded) {
            return Collections.emptyList();
        }
        return this.importedModule.getChildren();
    }

    public String toString() {
        return "import '" + this.ast.getFirstChild().getText() + "'";
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isFound() {
        return this.found;
    }

    public IModule getModule() {
        return this.importedModule;
    }

    public String getPath() {
        return this.ast.getFirstChild().getText();
    }

    public void setContext(IEolContext context) {
        if (this.importedModule instanceof IEolLibraryModule) {
            IEolLibraryModule module = (IEolLibraryModule)this.importedModule;
            module.setContext(context);
            for (EolImport import_ : module.getImports()) {
                import_.setContext(context);
            }
        }
    }
}

