/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection.recording;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;
import org.eclipse.epsilon.eol.execute.introspection.recording.IPropertyAccessRecorder;

public class PropertyAccessExecutionListener
implements IExecutionListener {
    private final Collection<IPropertyAccessRecorder> recorders = new LinkedList<IPropertyAccessRecorder>();
    private final WeakHashMap<AST, Object> cache = new WeakHashMap();

    public PropertyAccessExecutionListener(IPropertyAccessRecorder ... recorders) {
        this.recorders.addAll(Arrays.asList(recorders));
    }

    @Override
    public void aboutToExecute(AST ast, IEolContext context) {
    }

    @Override
    public void finishedExecuting(AST ast, Object result, IEolContext context) {
        String propertyName;
        Object modelElement;
        if (this.isLeftHandSideOfPointExpression(ast)) {
            this.cache.put(ast, result);
        }
        if (this.isPropertyAccessExpression(ast) && this.isModelBasedProperty(modelElement = this.cache.get(ast.getFirstChild()), propertyName = ast.getSecondChild().getText(), context)) {
            for (IPropertyAccessRecorder recorder : this.recorders) {
                recorder.record(modelElement, propertyName);
            }
        }
    }

    private boolean isLeftHandSideOfPointExpression(AST ast) {
        return ast.getParent().getType() == 9 && ast.getParent().getFirstChild() == ast;
    }

    private boolean isPropertyAccessExpression(AST ast) {
        return ast.getType() == 9 && ast.getSecondChild().getChildCount() == 0 && !this.isAssignee(ast);
    }

    private boolean isModelBasedProperty(Object object, String property, IEolContext context) {
        return context.getIntrospectionManager().isModelBasedProperty(object, property, context);
    }

    private boolean isAssignee(AST ast) {
        return ast.getParent().getType() == 26 && ast.getParent().getFirstChild() == ast;
    }
}

