/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.checker;

import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;

public class IgnoredPropertyChecker {
    private final String originalType;
    private final MigrationStrategyCheckingContext context;

    public IgnoredPropertyChecker(String originalType, MigrationStrategyCheckingContext context) {
        this.originalType = originalType;
        this.context = context;
    }

    public void check(String property) {
        try {
            if (!this.context.isPropertyInOriginalMetamodel(this.originalType, property)) {
                this.context.addWarning("The " + property + " property should be ignored, " + "but there is no " + property + " property defined " + "for " + this.originalType + " in the original metamodel.");
            }
        }
        catch (FlockRuntimeException flockRuntimeException) {
            // empty catch block
        }
    }
}

