/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.generate;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.emc.emf.AbstractEmfModel;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.hutn.exceptions.HutnGenerationException;

public abstract class AbstractGenerator {
    public EmfModel generate(String uri) throws HutnGenerationException {
        Resource resource = uri == null ? EmfUtil.createResource() : EmfUtil.createResource(URI.createURI(uri));
        return this.generate(resource);
    }

    public void store(File path) throws HutnGenerationException {
        CachedModel target = null;
        try {
            URI fileUri = URI.createFileURI(path.getAbsolutePath());
            target = this.generate(EmfUtil.createResource(fileUri));
            ((AbstractEmfModel)target).store(fileUri);
        }
        finally {
            if (target != null) {
                target.dispose();
            }
        }
    }

    protected abstract EmfModel generate(Resource var1) throws HutnGenerationException;
}

