/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;

public class ObjectiveComparator<S extends Solution<?>>
implements Comparator<S> {
    private int objectiveId;
    private Ordering order;

    public ObjectiveComparator(int objectiveId) {
        this.objectiveId = objectiveId;
        this.order = Ordering.ASCENDING;
    }

    public ObjectiveComparator(int objectiveId, Ordering order) {
        this.objectiveId = objectiveId;
        this.order = order;
    }

    @Override
    public int compare(S solution1, S solution2) {
        int result;
        if (solution1 == null) {
            result = solution2 == null ? 0 : 1;
        } else if (solution2 == null) {
            result = -1;
        } else {
            if (solution1.getNumberOfObjectives() <= this.objectiveId) {
                throw new JMetalException("The solution1 has " + solution1.getNumberOfObjectives() + " objectives " + "and the objective to sort is " + this.objectiveId);
            }
            if (solution2.getNumberOfObjectives() <= this.objectiveId) {
                throw new JMetalException("The solution2 has " + solution2.getNumberOfObjectives() + " objectives " + "and the objective to sort is " + this.objectiveId);
            }
            Double objective1 = solution1.getObjective(this.objectiveId);
            Double objective2 = solution2.getObjective(this.objectiveId);
            result = this.order == Ordering.ASCENDING ? Double.compare(objective1, objective2) : Double.compare(objective2, objective1);
        }
        return result;
    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }
}

