/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.benchmark;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.Util;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;

public class RangeQueryBenchmarkAlgorithm<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, Result> {
    private static final Logging LOG = Logging.getLogger(RangeQueryBenchmarkAlgorithm.class);
    protected DatabaseConnection queries = null;
    protected double sampling = -1.0;
    protected RandomFactory random;

    public RangeQueryBenchmarkAlgorithm(DistanceFunction<? super O> distanceFunction, DatabaseConnection databaseConnection, double d, RandomFactory randomFactory) {
        super(distanceFunction);
        this.queries = databaseConnection;
        this.sampling = d;
        this.random = randomFactory;
    }

    public Result run(Database database, Relation<O> relation, Relation<NumberVector> relation2) {
        if (this.queries != null) {
            throw new AbortException("This 'run' method will not use the given query set!");
        }
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<O> rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        DBIDs dBIDs = DBIDUtil.randomSample(relation.getDBIDs(), this.sampling, this.random);
        FiniteProgress finiteProgress = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", dBIDs.size(), LOG) : null;
        int n = 0;
        MeanVariance meanVariance = new MeanVariance();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d = relation2.get(dBIDIter).doubleValue(0);
            DoubleDBIDList doubleDBIDList = rangeQuery.getRangeForDBID(dBIDIter, d);
            int n2 = 0;
            DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
            while (doubleDBIDListIter.valid()) {
                n2 += DBIDUtil.asInteger(doubleDBIDListIter);
                doubleDBIDListIter.advance();
            }
            n = Util.mixHashCodes(n, n2);
            meanVariance.put(doubleDBIDList.size());
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics("Result hashcode: " + n);
            LOG.statistics("Mean number of results: " + meanVariance.getMean() + " +- " + meanVariance.getNaiveStddev());
        }
        return null;
    }

    public Result run(Database database, Relation<O> relation) {
        if (this.queries == null) {
            throw new AbortException("A query set is required for this 'run' method.");
        }
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<O> rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        NumberVector.Factory<O> factory = RelationUtil.getNumberVectorFactory(relation);
        int n = RelationUtil.dimensionality(relation);
        VectorFieldTypeInformation<NumberVector> vectorFieldTypeInformation = VectorFieldTypeInformation.typeRequest(NumberVector.class, n + 1, n + 1);
        MultipleObjectsBundle multipleObjectsBundle = this.queries.loadData();
        int n2 = -1;
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            if (!vectorFieldTypeInformation.isAssignableFromType(multipleObjectsBundle.meta(i))) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("No compatible data type in query input was found. Expected: ");
            stringBuilder.append(((Object)vectorFieldTypeInformation).toString());
            stringBuilder.append(" have: ");
            for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
                if (i > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(multipleObjectsBundle.meta(i).toString());
            }
            throw new AbortException(stringBuilder.toString());
        }
        DBIDRange dBIDRange = DBIDUtil.generateStaticDBIDRange(multipleObjectsBundle.dataLength());
        DBIDs dBIDs = DBIDUtil.randomSample((DBIDs)dBIDRange, this.sampling, this.random);
        FiniteProgress finiteProgress = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", dBIDs.size(), LOG) : null;
        int n3 = 0;
        MeanVariance meanVariance = new MeanVariance();
        double[] dArray = new double[n];
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            int n4 = dBIDRange.binarySearch(dBIDIter);
            assert (n4 >= 0);
            NumberVector numberVector = (NumberVector)multipleObjectsBundle.data(n4, n2);
            for (int i = 0; i < n; ++i) {
                dArray[i] = numberVector.doubleValue(i);
            }
            O o = factory.newNumberVector(dArray);
            double d = numberVector.doubleValue(n);
            DoubleDBIDList doubleDBIDList = rangeQuery.getRangeForObject(o, d);
            int n5 = 0;
            DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
            while (doubleDBIDListIter.valid()) {
                n5 += DBIDUtil.asInteger(doubleDBIDListIter);
                doubleDBIDListIter.advance();
            }
            n3 = Util.mixHashCodes(n3, n5);
            meanVariance.put(doubleDBIDList.size());
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics("Result hashcode: " + n3);
            LOG.statistics("Mean number of results: " + meanVariance.getMean() + " +- " + meanVariance.getNaiveStddev());
        }
        return null;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        if (this.queries == null) {
            return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
        }
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID QUERY_ID = new OptionID("rangebench.query", "Data source for the queries. If not set, the queries are taken from the database.");
        public static final OptionID SAMPLING_ID = new OptionID("rangebench.sampling", "Sampling size parameter. If the value is less or equal 1, it is assumed to be the relative share. Larger values will be interpreted as integer sizes. By default, all data will be used.");
        public static final OptionID RANDOM_ID = new OptionID("rangebench.random", "Random generator for sampling.");
        protected DatabaseConnection queries = null;
        protected double sampling = -1.0;
        protected RandomFactory random;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(QUERY_ID, DatabaseConnection.class);
            objectParameter.setOptional(true);
            if (parameterization.grab(objectParameter)) {
                this.queries = (DatabaseConnection)objectParameter.instantiateClass(parameterization);
            }
            DoubleParameter doubleParameter = new DoubleParameter(SAMPLING_ID);
            doubleParameter.setOptional(true);
            if (parameterization.grab(doubleParameter)) {
                this.sampling = doubleParameter.doubleValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT))) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected RangeQueryBenchmarkAlgorithm<O> makeInstance() {
            return new RangeQueryBenchmarkAlgorithm(this.distanceFunction, this.queries, this.sampling, this.random);
        }
    }
}

