/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractIndexBasedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SharedNearestNeighborSimilarityFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Title(value="SNN: Shared Nearest Neighbor Clustering")
@Description(value="Algorithm to find shared-nearest-neighbors-density-connected sets in a database based on the parameters 'minPts' and 'epsilon' (specifying a volume). These two parameters determine a density threshold for clustering.")
@Reference(authors="L. Ert\u00f6z, M. Steinbach, V. Kumar", title="Finding Clusters of Different Sizes, Shapes, and Densities in Noisy, High Dimensional Data", booktitle="Proc. of SIAM Data Mining (SDM), 2003", url="http://www.siam.org/meetings/sdm03/proceedings/sdm03_05.pdf")
public class SNNClustering<O>
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(SNNClustering.class);
    private int epsilon;
    private int minpts;
    protected List<ModifiableDBIDs> resultList;
    protected ModifiableDBIDs noise;
    protected ModifiableDBIDs processedIDs;
    private SharedNearestNeighborSimilarityFunction<O> similarityFunction;

    public SNNClustering(SharedNearestNeighborSimilarityFunction<O> sharedNearestNeighborSimilarityFunction, int n, int n2) {
        this.similarityFunction = sharedNearestNeighborSimilarityFunction;
        this.epsilon = n;
        this.minpts = n2;
    }

    public Clustering<Model> run(Database database, Relation<O> relation) {
        Object object;
        AbstractIndexBasedSimilarityFunction.Instance instance = this.similarityFunction.instantiate(relation);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("SNNClustering", relation.size(), LOG) : null;
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters", LOG) : null;
        this.resultList = new ArrayList<ModifiableDBIDs>();
        this.noise = DBIDUtil.newHashSet();
        this.processedIDs = DBIDUtil.newHashSet(relation.size());
        if (relation.size() >= this.minpts) {
            object = relation.iterDBIDs();
            while (object.valid()) {
                if (!this.processedIDs.contains((DBIDRef)object)) {
                    this.expandCluster(instance, (DBIDRef)object, finiteProgress, indefiniteProgress);
                    if (this.processedIDs.size() == relation.size() && this.noise.size() == 0) break;
                }
                if (finiteProgress != null && indefiniteProgress != null) {
                    finiteProgress.setProcessed(this.processedIDs.size(), LOG);
                    indefiniteProgress.setProcessed(this.resultList.size(), LOG);
                }
                object.advance();
            }
        } else {
            object = relation.iterDBIDs();
            while (object.valid()) {
                this.noise.add((DBIDRef)object);
                if (finiteProgress != null && indefiniteProgress != null) {
                    finiteProgress.setProcessed(this.noise.size(), LOG);
                    indefiniteProgress.setProcessed(this.resultList.size(), LOG);
                }
                object.advance();
            }
        }
        LOG.ensureCompleted(finiteProgress);
        LOG.setCompleted(indefiniteProgress);
        object = new Clustering("Shared-Nearest-Neighbor Clustering", "snn-clustering");
        Iterator<ModifiableDBIDs> iterator = this.resultList.iterator();
        while (iterator.hasNext()) {
            ((Clustering)object).addToplevelCluster(new Cluster<ClusterModel>((DBIDs)iterator.next(), ClusterModel.CLUSTER));
        }
        ((Clustering)object).addToplevelCluster(new Cluster<ClusterModel>(this.noise, true, ClusterModel.CLUSTER));
        return object;
    }

    protected ArrayModifiableDBIDs findSNNNeighbors(SimilarityQuery<O> similarityQuery, DBIDRef dBIDRef) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        DBIDIter dBIDIter = similarityQuery.getRelation().iterDBIDs();
        while (dBIDIter.valid()) {
            if (similarityQuery.similarity(dBIDRef, (DBIDRef)dBIDIter) >= (double)this.epsilon) {
                arrayModifiableDBIDs.add(dBIDIter);
            }
            dBIDIter.advance();
        }
        return arrayModifiableDBIDs;
    }

    protected void expandCluster(SimilarityQuery<O> similarityQuery, DBIDRef dBIDRef, FiniteProgress finiteProgress, IndefiniteProgress indefiniteProgress) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = this.findSNNNeighbors(similarityQuery, dBIDRef);
        if (arrayModifiableDBIDs.size() < this.minpts) {
            this.noise.add(dBIDRef);
            this.processedIDs.add(dBIDRef);
            if (finiteProgress != null && indefiniteProgress != null) {
                finiteProgress.setProcessed(this.processedIDs.size(), LOG);
                indefiniteProgress.setProcessed(this.resultList.size(), LOG);
            }
            return;
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray();
        DBIDRef dBIDRef2 = arrayModifiableDBIDs.iter();
        while (dBIDRef2.valid()) {
            if (!this.processedIDs.contains(dBIDRef2)) {
                arrayModifiableDBIDs2.add(dBIDRef2);
                this.processedIDs.add(dBIDRef2);
            } else if (this.noise.contains(dBIDRef2)) {
                arrayModifiableDBIDs2.add(dBIDRef2);
                this.noise.remove(dBIDRef2);
            }
            dBIDRef2.advance();
        }
        dBIDRef2 = DBIDUtil.newVar();
        while (arrayModifiableDBIDs.size() > 0) {
            arrayModifiableDBIDs.pop((DBIDVar)dBIDRef2);
            ArrayModifiableDBIDs arrayModifiableDBIDs3 = this.findSNNNeighbors(similarityQuery, dBIDRef2);
            if (arrayModifiableDBIDs3.size() >= this.minpts) {
                DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs3.iter();
                while (dBIDArrayMIter.valid()) {
                    boolean bl;
                    boolean bl2 = this.noise.contains(dBIDArrayMIter);
                    boolean bl3 = bl = !this.processedIDs.contains(dBIDArrayMIter);
                    if (bl2 || bl) {
                        if (bl) {
                            arrayModifiableDBIDs.add(dBIDArrayMIter);
                        }
                        arrayModifiableDBIDs2.add(dBIDArrayMIter);
                        this.processedIDs.add(dBIDArrayMIter);
                        if (bl2) {
                            this.noise.remove(dBIDArrayMIter);
                        }
                    }
                    dBIDArrayMIter.advance();
                }
            }
            if (finiteProgress != null && indefiniteProgress != null) {
                finiteProgress.setProcessed(this.processedIDs.size(), LOG);
                int n = arrayModifiableDBIDs2.size() > this.minpts ? this.resultList.size() + 1 : this.resultList.size();
                indefiniteProgress.setProcessed(n, LOG);
            }
            if (this.processedIDs.size() != similarityQuery.getRelation().size() || this.noise.size() != 0) continue;
            break;
        }
        if (arrayModifiableDBIDs2.size() >= this.minpts) {
            this.resultList.add(arrayModifiableDBIDs2);
        } else {
            this.noise.addDBIDs(arrayModifiableDBIDs2);
            this.noise.add(dBIDRef);
            this.processedIDs.add(dBIDRef);
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.similarityFunction.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID EPSILON_ID = new OptionID("snn.epsilon", "The minimum SNN density.");
        public static final OptionID MINPTS_ID = new OptionID("snn.minpts", "Threshold for minimum number of points in the epsilon-SNN-neighborhood of a point.");
        protected int epsilon;
        protected int minpts;
        private SharedNearestNeighborSimilarityFunction<O> similarityFunction;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(SharedNearestNeighborSimilarityFunction.class);
            this.similarityFunction = (SharedNearestNeighborSimilarityFunction)parameterization.tryInstantiate(clazz);
            IntParameter intParameter = new IntParameter(EPSILON_ID);
            if (parameterization.grab(intParameter)) {
                this.epsilon = (Integer)intParameter.getValue();
            }
            IntParameter intParameter2 = new IntParameter(MINPTS_ID);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.minpts = intParameter2.intValue();
            }
        }

        @Override
        protected SNNClustering<O> makeInstance() {
            return new SNNClustering<O>(this.similarityFunction, this.epsilon, this.minpts);
        }
    }
}

