/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation.AffinityPropagationInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.affinitypropagation.DistanceBasedInitializationWithMedian;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.MutableProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import gnu.trove.map.hash.TIntObjectHashMap;

@Title(value="Affinity Propagation: Clustering by Passing Messages Between Data Points")
@Reference(title="Clustering by Passing Messages Between Data Points", authors="B. J. Frey and D. Dueck", booktitle="Science Vol 315", url="http://dx.doi.org/10.1126/science.1136800")
public class AffinityPropagationClusteringAlgorithm<O>
extends AbstractAlgorithm<Clustering<MedoidModel>>
implements ClusteringAlgorithm<Clustering<MedoidModel>> {
    private static final Logging LOG = Logging.getLogger(AffinityPropagationClusteringAlgorithm.class);
    AffinityPropagationInitialization<O> initialization;
    double lambda = 0.5;
    int convergence = 10;
    int maxiter = 1000;

    public AffinityPropagationClusteringAlgorithm(AffinityPropagationInitialization<O> affinityPropagationInitialization, double d, int n, int n2) {
        this.initialization = affinityPropagationInitialization;
        this.lambda = d;
        this.convergence = n;
        this.maxiter = n2;
    }

    public Clustering<MedoidModel> run(Database database, Relation<O> relation) {
        int n;
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        int n2 = arrayDBIDs.size();
        int[] nArray = new int[n2];
        double[][] dArray = this.initialization.getSimilarityMatrix(database, relation, arrayDBIDs);
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Affinity Propagation Iteration", LOG) : null;
        MutableProgress mutableProgress = LOG.isVerbose() ? new MutableProgress("Stable assignments", n2 + 1, LOG) : null;
        int n3 = 0;
        for (int i = 0; i < this.maxiter && n3 < this.convergence; ++i) {
            double d;
            double[] dArray4;
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                double d2;
                int n5;
                double[] dArray5 = dArray3[n4];
                dArray4 = dArray2[n4];
                double[] dArray6 = dArray[n4];
                d = Double.NEGATIVE_INFINITY;
                double d3 = Double.NEGATIVE_INFINITY;
                int n6 = -1;
                for (n5 = 0; n5 < n2; ++n5) {
                    d2 = dArray5[n5] + dArray6[n5];
                    if (d2 > d) {
                        d3 = d;
                        d = d2;
                        n6 = n5;
                        continue;
                    }
                    if (!(d2 > d3)) continue;
                    d3 = d2;
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    d2 = dArray6[n5] - (n5 != n6 ? d : d3);
                    dArray4[n5] = dArray4[n5] * this.lambda + d2 * (1.0 - this.lambda);
                }
            }
            for (n4 = 0; n4 < n2; ++n4) {
                int n7;
                double d4 = 0.0;
                for (n7 = 0; n7 < n2; ++n7) {
                    if (n7 != n4 && !(dArray2[n7][n4] > 0.0)) continue;
                    d4 += dArray2[n7][n4];
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    d = d4;
                    if (n7 == n4 || dArray2[n7][n4] > 0.0) {
                        d -= dArray2[n7][n4];
                    }
                    if (n7 != n4 && d > 0.0) {
                        d = 0.0;
                    }
                    dArray3[n7][n4] = dArray3[n7][n4] * this.lambda + d * (1.0 - this.lambda);
                }
            }
            n4 = 0;
            for (n = 0; n < n2; ++n) {
                dArray4 = dArray3[n];
                double[] dArray7 = dArray2[n];
                d = Double.NEGATIVE_INFINITY;
                int n8 = -1;
                for (int j = 0; j < n2; ++j) {
                    double d5 = dArray4[j] + dArray7[j];
                    if (!(d5 > d) && (n != j || !(d5 >= d))) continue;
                    d = d5;
                    n8 = j;
                }
                if (nArray[n] == n8) continue;
                ++n4;
                nArray[n] = n8;
            }
            n3 = n4 > 0 ? 0 : n3 + 1;
            LOG.incrementProcessed(indefiniteProgress);
            if (mutableProgress == null) continue;
            mutableProgress.setProcessed(n2 - n4, LOG);
        }
        if (mutableProgress != null) {
            mutableProgress.setProcessed(mutableProgress.getTotal(), LOG);
        }
        LOG.setCompleted(indefiniteProgress);
        TIntObjectHashMap<ModifiableDBIDs> tIntObjectHashMap = new TIntObjectHashMap<ModifiableDBIDs>();
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        n = 0;
        while (dBIDArrayIter.valid()) {
            int n9 = nArray[n];
            ModifiableDBIDs modifiableDBIDs = (ModifiableDBIDs)tIntObjectHashMap.get(n9);
            if (modifiableDBIDs == null) {
                modifiableDBIDs = DBIDUtil.newArray();
                tIntObjectHashMap.put(n9, modifiableDBIDs);
            }
            modifiableDBIDs.add(dBIDArrayIter);
            dBIDArrayIter.advance();
            ++n;
        }
        Object object = tIntObjectHashMap.iterator();
        while (object.hasNext()) {
            int n10;
            object.advance();
            int n11 = n10 = object.key();
            ModifiableDBIDs modifiableDBIDs = null;
            while (arrayDBIDs == null && nArray[n11] != n11) {
                n11 = nArray[n11];
                modifiableDBIDs = (ModifiableDBIDs)tIntObjectHashMap.get(n11);
            }
            if (modifiableDBIDs == null || n11 == n10) continue;
            modifiableDBIDs.addDBIDs((DBIDs)object.value());
            object.remove();
        }
        object = new Clustering("Affinity Propagation Clustering", "ap-clustering");
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        Object object2 = tIntObjectHashMap.iterator();
        while (object2.hasNext()) {
            object2.advance();
            dBIDArrayIter.seek(object2.key());
            if (((ModifiableDBIDs)object2.value()).size() > 1) {
                MedoidModel medoidModel = new MedoidModel(DBIDUtil.deref(dBIDArrayIter));
                ((Clustering)object).addToplevelCluster(new Cluster<MedoidModel>((DBIDs)object2.value(), medoidModel));
                continue;
            }
            arrayModifiableDBIDs.add(dBIDArrayIter);
        }
        if (arrayModifiableDBIDs.size() > 0) {
            object2 = new MedoidModel(DBIDUtil.deref(arrayModifiableDBIDs.iter()));
            ((Clustering)object).addToplevelCluster(new Cluster<Object>(arrayModifiableDBIDs, true, object2));
        }
        return object;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.initialization.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID INITIALIZATION_ID = new OptionID("ap.initialization", "Similarity matrix initialization..");
        public static final OptionID LAMBDA_ID = new OptionID("ap.lambda", "Dampening factor lambda. Usually 0.5 to 1.");
        public static final OptionID CONVERGENCE_ID = new OptionID("ap.convergence", "Number of stable iterations for convergence.");
        public static final OptionID MAXITER_ID = new OptionID("ap.maxiter", "Maximum number of iterations.");
        AffinityPropagationInitialization<O> initialization;
        double lambda = 0.5;
        int convergence;
        int maxiter;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(INITIALIZATION_ID, (Class<?>)AffinityPropagationInitialization.class, DistanceBasedInitializationWithMedian.class);
            if (parameterization.grab(objectParameter)) {
                this.initialization = (AffinityPropagationInitialization)objectParameter.instantiateClass(parameterization);
            }
            DoubleParameter doubleParameter = new DoubleParameter(LAMBDA_ID, 0.5);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.lambda = doubleParameter.doubleValue();
            }
            IntParameter intParameter2 = new IntParameter(CONVERGENCE_ID, 15);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.convergence = intParameter2.intValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(MAXITER_ID, 1000))) {
                this.maxiter = intParameter.intValue();
            }
        }

        @Override
        protected AffinityPropagationClusteringAlgorithm<O> makeInstance() {
            return new AffinityPropagationClusteringAlgorithm<O>(this.initialization, this.lambda, this.convergence, this.maxiter);
        }
    }
}

