/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.biclustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.BiclusterModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import java.util.BitSet;

public abstract class AbstractBiclustering<V extends NumberVector, M extends BiclusterModel>
extends AbstractAlgorithm<Clustering<M>>
implements ClusteringAlgorithm<Clustering<M>> {
    private Database database;
    protected Relation<V> relation;
    private DBIDArrayIter iter;
    protected ArrayDBIDs rowIDs;
    private int colDim;

    protected AbstractBiclustering() {
    }

    public final Clustering<M> run(Relation<V> relation) {
        this.relation = relation;
        if (this.relation == null || this.relation.size() == 0) {
            throw new IllegalArgumentException("database empty: must contain elements");
        }
        this.colDim = RelationUtil.dimensionality(relation);
        this.rowIDs = DBIDUtil.ensureArray(this.relation.getDBIDs());
        this.iter = this.rowIDs.iter();
        return this.biclustering();
    }

    protected abstract Clustering<M> biclustering();

    protected int[] colsBitsetToIDs(BitSet bitSet) {
        int[] nArray = new int[bitSet.cardinality()];
        int n = 0;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            nArray[n] = n2;
            ++n;
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return nArray;
    }

    protected ArrayDBIDs rowsBitsetToIDs(BitSet bitSet) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(bitSet.cardinality());
        DBIDArrayIter dBIDArrayIter = this.rowIDs.iter();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            dBIDArrayIter.seek(n);
            arrayModifiableDBIDs.add(dBIDArrayIter);
            n = bitSet.nextSetBit(n + 1);
        }
        return arrayModifiableDBIDs;
    }

    protected Cluster<BiclusterModel> defineBicluster(BitSet bitSet, BitSet bitSet2) {
        ArrayDBIDs arrayDBIDs = this.rowsBitsetToIDs(bitSet);
        int[] nArray = this.colsBitsetToIDs(bitSet2);
        return new Cluster<BiclusterModel>((DBIDs)arrayDBIDs, new BiclusterModel(nArray));
    }

    protected Cluster<BiclusterModel> defineBicluster(long[] lArray, long[] lArray2) {
        ArrayDBIDs arrayDBIDs = this.rowsBitsetToIDs(lArray);
        int[] nArray = this.colsBitsetToIDs(lArray2);
        return new Cluster<BiclusterModel>((DBIDs)arrayDBIDs, new BiclusterModel(nArray));
    }

    protected double valueAt(int n, int n2) {
        this.iter.seek(n);
        return ((NumberVector)this.relation.get(this.iter)).doubleValue(n2);
    }

    @Deprecated
    protected DBID getRowDBID(int n) {
        return this.rowIDs.get(n);
    }

    protected int[] colsBitsetToIDs(long[] lArray) {
        int[] nArray = new int[BitsUtil.cardinality(lArray)];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            if (l == 0L) {
                n2 += 64;
                continue;
            }
            int n3 = 0;
            while (n3 < 64) {
                if ((l & 1L) == 1L) {
                    nArray[n] = n2;
                    ++n;
                }
                ++n3;
                ++n2;
                l >>>= 1;
            }
        }
        return nArray;
    }

    protected ArrayDBIDs rowsBitsetToIDs(long[] lArray) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(BitsUtil.cardinality(lArray));
        DBIDArrayIter dBIDArrayIter = this.rowIDs.iter();
        block0: for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            if (l == 0L) {
                dBIDArrayIter.advance(64);
                continue;
            }
            int n = 0;
            while (n < 64) {
                if (!dBIDArrayIter.valid()) break block0;
                if ((l & 1L) == 1L) {
                    arrayModifiableDBIDs.add(dBIDArrayIter);
                }
                ++n;
                l >>>= 1;
                dBIDArrayIter.advance();
            }
        }
        return arrayModifiableDBIDs;
    }

    protected int getRowDim() {
        return this.rowIDs.size();
    }

    protected int getColDim() {
        return this.colDim;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Relation<V> getRelation() {
        return this.relation;
    }
}

