/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.CorrelationClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.GeneralizedOPTICS;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.preprocessed.localpca.FilteredLocalPCAIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.localpca.KNNQueryFilteredPCAIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PercentageEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.Comparator;

@Title(value="Mining Hierarchies of Correlation Clusters")
@Description(value="Algorithm for detecting hierarchies of correlation clusters.")
@Reference(authors="E. Achtert, C. B\u00f6hm, P. Kr\u00f6ger, A. Zimek", title="Mining Hierarchies of Correlation Clusters", booktitle="Proc. Int. Conf. on Scientific and Statistical Database Management (SSDBM'06), Vienna, Austria, 2006", url="http://dx.doi.org/10.1109/SSDBM.2006.35")
public class HiCO<V extends NumberVector>
extends GeneralizedOPTICS<V, CorrelationClusterOrder> {
    private static final Logging LOG = Logging.getLogger(HiCO.class);
    public static final double DEFAULT_DELTA = 0.25;
    public static final double DEFAULT_ALPHA = 0.85;
    private IndexFactory<V, FilteredLocalPCAIndex<NumberVector>> indexfactory;
    double delta;
    int mu;

    public HiCO(IndexFactory<V, FilteredLocalPCAIndex<NumberVector>> indexFactory, int n, double d) {
        this.mu = n;
        this.indexfactory = indexFactory;
        this.delta = d;
    }

    public CorrelationClusterOrder run(Database database, Relation<V> relation) {
        if (this.mu >= relation.size()) {
            throw new AbortException("Parameter mu is chosen unreasonably large. This won't yield meaningful results.");
        }
        return new Instance(database, relation).run();
    }

    public int correlationDistance(PCAFilteredResult pCAFilteredResult, PCAFilteredResult pCAFilteredResult2, int n) {
        int n2;
        Matrix matrix = pCAFilteredResult.getEigenvectors().copy();
        Matrix matrix2 = pCAFilteredResult.adapatedStrongEigenvectors().copy();
        Matrix matrix3 = pCAFilteredResult.selectionMatrixOfStrongEigenvectors().copy();
        int n3 = pCAFilteredResult.getCorrelationDimension();
        Matrix matrix4 = pCAFilteredResult2.getEigenvectors().copy();
        Matrix matrix5 = pCAFilteredResult2.adapatedStrongEigenvectors().copy();
        Matrix matrix6 = pCAFilteredResult2.selectionMatrixOfStrongEigenvectors().copy();
        int n4 = pCAFilteredResult2.getCorrelationDimension();
        Matrix matrix7 = pCAFilteredResult.dissimilarityMatrix();
        for (int i = 0; i < matrix5.getColumnDimensionality(); ++i) {
            Vector vector = matrix5.getCol(i);
            double d = Math.sqrt(vector.transposeTimes(vector) - vector.transposeTimesTimes(matrix7, vector));
            if (n3 >= n || !(d > this.delta)) continue;
            this.adjust(matrix, matrix3, vector, n3++);
            matrix7 = matrix.times(matrix3).timesTranspose(matrix);
        }
        Matrix matrix8 = pCAFilteredResult2.dissimilarityMatrix();
        for (n2 = 0; n2 < matrix2.getColumnDimensionality(); ++n2) {
            Vector vector = matrix2.getCol(n2);
            double d = Math.sqrt(vector.transposeTimes(vector) - vector.transposeTimes(matrix8).times(vector).get(0));
            if (n4 >= n || !(d > this.delta)) continue;
            this.adjust(matrix4, matrix6, vector, n4++);
            matrix8 = matrix4.times(matrix6).timesTranspose(matrix4);
        }
        n2 = Math.max(n3, n4);
        return n2;
    }

    private void adjust(Matrix matrix, Matrix matrix2, Vector vector, int n) {
        int n2 = matrix.getRowDimensionality();
        matrix2.set(n, n, 1.0);
        Vector vector2 = vector.copy();
        Vector vector3 = new Vector(n2);
        for (int i = 0; i < n; ++i) {
            Vector vector4 = matrix.getCol(i);
            vector3.plusTimesEquals(vector4, vector2.transposeTimes(vector4));
        }
        vector2.minusEquals(vector3);
        vector2.normalize();
        matrix.setCol(n, vector2);
    }

    @Override
    public int getMinPts() {
        return this.mu;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.indexfactory.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID MU_ID = new OptionID("hico.mu", "Specifies the smoothing factor. The mu-nearest neighbor is used to compute the correlation reachability of an object.");
        public static final OptionID K_ID = new OptionID("hico.k", "Optional parameter to specify the number of nearest neighbors considered in the PCA. If this parameter is not set, k is set to the value of parameter mu.");
        public static final OptionID DELTA_ID = new OptionID("hico.delta", "Threshold of a distance between a vector q and a given space that indicates that q adds a new dimension to the space.");
        public static final OptionID ALPHA_ID = new OptionID("hico.alpha", "The threshold for 'strong' eigenvectors: the 'strong' eigenvectors explain a portion of at least alpha of the total variance.");
        int mu = -1;
        double delta;
        private IndexFactory<V, FilteredLocalPCAIndex<NumberVector>> indexfactory;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(MU_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.mu = (Integer)intParameter.getValue();
            }
            IntParameter intParameter2 = new IntParameter(K_ID);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            intParameter2.setOptional(true);
            int n = parameterization.grab(intParameter2) ? (Integer)intParameter2.getValue() : this.mu;
            DoubleParameter doubleParameter = new DoubleParameter(DELTA_ID, 0.25);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            this.delta = 0.25;
            if (parameterization.grab(doubleParameter)) {
                this.delta = doubleParameter.doubleValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(ALPHA_ID, 0.85);
            doubleParameter2.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter2.addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
            double d = 0.85;
            if (parameterization.grab(doubleParameter2)) {
                d = doubleParameter2.doubleValue();
            }
            ListParameterization listParameterization = new ListParameterization();
            listParameterization.addParameter(KNNQueryFilteredPCAIndex.Factory.Parameterizer.K_ID, n);
            listParameterization.addParameter(PercentageEigenPairFilter.Parameterizer.ALPHA_ID, d);
            ChainedParameterization chainedParameterization = new ChainedParameterization(listParameterization, parameterization);
            chainedParameterization.errorsTo(parameterization);
            Class clazz = ClassGenericsUtil.uglyCrossCast(KNNQueryFilteredPCAIndex.Factory.class, IndexFactory.class);
            this.indexfactory = (IndexFactory)chainedParameterization.tryInstantiate(clazz);
        }

        @Override
        protected HiCO<V> makeInstance() {
            return new HiCO<V>(this.indexfactory, this.mu, this.delta);
        }
    }

    private class Instance
    extends GeneralizedOPTICS.Instance<V, CorrelationClusterOrder> {
        private FilteredLocalPCAIndex<NumberVector> index;
        private Relation<V> relation;
        private ArrayModifiableDBIDs clusterOrder;
        private WritableIntegerDataStore correlationValue;
        private WritableIntegerDataStore tmpCorrelation;
        private WritableDoubleDataStore tmpDistance;
        private ArrayModifiableDBIDs tmpIds;
        Comparator<DBIDRef> tmpcomp;

        public Instance(Database database, Relation<V> relation) {
            super(database, relation);
            this.tmpcomp = new Sorter();
            DBIDs dBIDs = relation.getDBIDs();
            this.clusterOrder = DBIDUtil.newArray(dBIDs.size());
            this.relation = relation;
            this.correlationValue = DataStoreUtil.makeIntegerStorage(dBIDs, 30, Integer.MAX_VALUE);
            this.tmpIds = DBIDUtil.newArray(dBIDs);
            this.tmpCorrelation = DataStoreUtil.makeIntegerStorage(dBIDs, 3);
            this.tmpDistance = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        }

        @Override
        public CorrelationClusterOrder run() {
            this.index = (FilteredLocalPCAIndex)HiCO.this.indexfactory.instantiate(this.relation);
            return (CorrelationClusterOrder)super.run();
        }

        @Override
        protected CorrelationClusterOrder buildResult() {
            return new CorrelationClusterOrder("HiCO Cluster Order", "hico-cluster-order", this.clusterOrder, this.reachability, this.predecessor, this.correlationValue);
        }

        @Override
        protected void initialDBID(DBIDRef dBIDRef) {
            this.correlationValue.put(dBIDRef, Integer.MAX_VALUE);
        }

        @Override
        protected void expandDBID(DBIDRef dBIDRef) {
            this.clusterOrder.add(dBIDRef);
            PCAFilteredResult pCAFilteredResult = this.index.getLocalProjection(dBIDRef);
            NumberVector numberVector = (NumberVector)this.relation.get(dBIDRef);
            int n = numberVector.getDimensionality();
            DBIDArrayMIter dBIDArrayMIter = this.tmpIds.iter();
            while (dBIDArrayMIter.valid()) {
                PCAFilteredResult pCAFilteredResult2 = this.index.getLocalProjection(dBIDArrayMIter);
                NumberVector numberVector2 = (NumberVector)this.relation.get(dBIDArrayMIter);
                this.tmpCorrelation.putInt(dBIDArrayMIter, HiCO.this.correlationDistance(pCAFilteredResult, pCAFilteredResult2, n));
                this.tmpDistance.putDouble(dBIDArrayMIter, EuclideanDistanceFunction.STATIC.distance(numberVector, numberVector2));
                dBIDArrayMIter.advance();
            }
            this.tmpIds.sort(this.tmpcomp);
            double d = this.tmpDistance.doubleValue(dBIDArrayMIter.seek(HiCO.this.mu - 1));
            dBIDArrayMIter.seek(0);
            while (dBIDArrayMIter.valid()) {
                int n2;
                int n3;
                if (!this.processedIDs.contains(dBIDArrayMIter) && (n3 = this.correlationValue.intValue(dBIDArrayMIter)) > (n2 = this.tmpCorrelation.intValue(dBIDArrayMIter))) {
                    double d2;
                    double d3 = MathUtil.max(this.tmpDistance.doubleValue(dBIDArrayMIter), d);
                    if (n3 != n2 || !((d2 = this.reachability.doubleValue(dBIDArrayMIter)) <= d3)) {
                        this.correlationValue.putInt(dBIDArrayMIter, n2);
                        this.reachability.putDouble(dBIDArrayMIter, d3);
                        this.predecessor.putDBID(dBIDArrayMIter, dBIDRef);
                        if (n3 == Integer.MAX_VALUE) {
                            this.candidates.add(dBIDArrayMIter);
                        }
                    }
                }
                dBIDArrayMIter.advance();
            }
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            int n;
            int n2 = this.correlationValue.intValue(dBIDRef);
            return n2 < (n = this.correlationValue.intValue(dBIDRef2)) ? -1 : (n2 > n ? 1 : super.compare(dBIDRef, dBIDRef2));
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }

        private final class Sorter
        implements Comparator<DBIDRef> {
            private Sorter() {
            }

            @Override
            public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
                int n;
                int n2 = Instance.this.tmpCorrelation.intValue(dBIDRef);
                return n2 < (n = Instance.this.tmpCorrelation.intValue(dBIDRef2)) ? -1 : (n2 > n ? 1 : Double.compare(Instance.this.tmpDistance.doubleValue(dBIDRef), Instance.this.tmpDistance.doubleValue(dBIDRef2)));
            }
        }
    }
}

