/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;

@Reference(authors="E. Bi\u00e7ici and D. Yuret", title="Locally Scaled Density Based Clustering", booktitle="Adaptive and Natural Computing Algorithms", url="http://dx.doi.org/10.1007/978-3-540-71618-1_82")
public class LSDBC<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static Logging LOG = Logging.getLogger(LSDBC.class);
    protected int k;
    protected double alpha;
    protected static int UNPROCESSED = 0;
    protected static int NOISE = 1;

    public LSDBC(DistanceFunction<? super O> distanceFunction, int n, double d) {
        super(distanceFunction);
        this.k = n + 1;
        this.alpha = d;
    }

    public Clustering<Model> run(Database database, Relation<O> relation) {
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("LSDBC", 3) : null;
        int n = RelationUtil.dimensionality(relation);
        double d = Math.pow(2.0, this.alpha / (double)n);
        DBIDs dBIDs = relation.getDBIDs();
        LOG.beginStep(stepProgress, 1, "Materializing kNN neighborhoods");
        KNNQuery<O> kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepProgress, 2, "Sorting by density");
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        this.fillDensities(kNNQuery, dBIDs, writableDoubleDataStore);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
        arrayModifiableDBIDs.sort(new DataStoreUtil.AscendingByDoubleDataStore(writableDoubleDataStore));
        LOG.beginStep(stepProgress, 3, "Computing clusters");
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("LSDBC Clustering", dBIDs.size(), LOG) : null;
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters found", LOG) : null;
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(dBIDs, 1, UNPROCESSED);
        TIntArrayList tIntArrayList = new TIntArrayList();
        tIntArrayList.add(0);
        tIntArrayList.add(0);
        int n2 = NOISE + 1;
        Object object = arrayModifiableDBIDs.iter();
        while (object.valid()) {
            if (writableIntegerDataStore.intValue((DBIDRef)object) == UNPROCESSED) {
                KNNList kNNList = kNNQuery.getKNNForDBID((DBIDRef)object, this.k);
                if (this.isLocalMaximum(kNNList.getKNNDistance(), kNNList, writableDoubleDataStore)) {
                    double d2 = d * kNNList.getKNNDistance();
                    writableIntegerDataStore.putInt((DBIDRef)object, n2);
                    tIntArrayList.add(this.expandCluster(n2, writableIntegerDataStore, kNNQuery, kNNList, d2, finiteProgress));
                    ++n2;
                    if (indefiniteProgress != null) {
                        indefiniteProgress.setProcessed(n2, LOG);
                    }
                } else {
                    writableIntegerDataStore.putInt((DBIDRef)object, NOISE);
                    tIntArrayList.set(NOISE, tIntArrayList.get(NOISE) + 1);
                }
                LOG.incrementProcessed(finiteProgress);
            }
            object.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        LOG.setCompleted(indefiniteProgress);
        LOG.setCompleted(stepProgress);
        object = new ArrayList(n2);
        for (int i = 0; i < tIntArrayList.size(); ++i) {
            ((ArrayList)object).add(DBIDUtil.newArray(tIntArrayList.get(i)));
        }
        Object object2 = dBIDs.iter();
        while (object2.valid()) {
            int n3 = writableIntegerDataStore.intValue((DBIDRef)object2);
            int bl = Math.abs(n3);
            ((ArrayModifiableDBIDs)((ArrayList)object).get(bl)).add((DBIDRef)object2);
            object2.advance();
        }
        writableIntegerDataStore.destroy();
        object2 = new Clustering("LSDBC", "lsdbc-clustering");
        for (int i = NOISE; i < ((ArrayList)object).size(); ++i) {
            boolean bl = i == NOISE;
            Cluster<ClusterModel> cluster = new Cluster<ClusterModel>((DBIDs)((ArrayList)object).get(i), bl, ClusterModel.CLUSTER);
            ((Clustering)object2).addToplevelCluster(cluster);
        }
        return object2;
    }

    private boolean isLocalMaximum(double d, DBIDs dBIDs, WritableDoubleDataStore writableDoubleDataStore) {
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            if (writableDoubleDataStore.doubleValue(dBIDIter) < d) {
                return false;
            }
            dBIDIter.advance();
        }
        return true;
    }

    protected int expandCluster(int n, WritableIntegerDataStore writableIntegerDataStore, KNNQuery<O> kNNQuery, DBIDs dBIDs, double d, FiniteProgress finiteProgress) {
        int n2 = 1;
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        arrayModifiableDBIDs.addDBIDs(dBIDs);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        while (!arrayModifiableDBIDs.isEmpty()) {
            arrayModifiableDBIDs.pop(dBIDVar);
            int n3 = writableIntegerDataStore.intValue(dBIDVar);
            if (n3 == NOISE) {
                ++n2;
                writableIntegerDataStore.putInt(dBIDVar, -n);
                continue;
            }
            if (n3 != UNPROCESSED) continue;
            ++n2;
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDVar, this.k);
            if (kNNList.getKNNDistance() <= d) {
                arrayModifiableDBIDs.addDBIDs(kNNList);
            }
            writableIntegerDataStore.putInt(dBIDVar, n);
            LOG.incrementProcessed(finiteProgress);
        }
        return n2;
    }

    private void fillDensities(KNNQuery<O> kNNQuery, DBIDs dBIDs, WritableDoubleDataStore writableDoubleDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Densities", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
            writableDoubleDataStore.putDouble(dBIDIter, kNNList.getKNNDistance());
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("lsdbc.k", "Neighborhood size (k)");
        public static final OptionID ALPHA_ID = new OptionID("lsdbc.alpha", "Density difference factor");
        protected int k;
        protected double alpha;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(ALPHA_ID).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.alpha = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LSDBC<O> makeInstance() {
            return new LSDBC(this.distanceFunction, this.k, this.alpha);
        }
    }
}

