/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.geometry.PrimsMinimumSpanningTree;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleLongHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="HDBSCAN: Hierarchical Density-Based Spatial Clustering of Applications with Noise")
@Description(value="Density-Based Clustering Based on Hierarchical Density Estimates")
@Reference(authors="R. J. G. B. Campello, D. Moulavi, and J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conference on Advances in Knowledge Discovery and Data Mining, PAKDD", url="http://dx.doi.org/10.1007/978-3-642-37456-2_14")
public abstract class AbstractHDBSCAN<O, R extends Result>
extends AbstractDistanceBasedAlgorithm<O, R> {
    protected final int minPts;

    public AbstractHDBSCAN(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.minPts = n;
    }

    protected WritableDoubleDataStore computeCoreDists(DBIDs dBIDs, KNNQuery<O> kNNQuery, int n) {
        Logging logging = this.getLogger();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 30);
        FiniteProgress finiteProgress = logging.isVerbose() ? new FiniteProgress("Computing core sizes", dBIDs.size(), logging) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            writableDoubleDataStore.put((DBIDRef)dBIDIter, kNNQuery.getKNNForDBID(dBIDIter, n).getKNNDistance());
            logging.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        logging.ensureCompleted(finiteProgress);
        return writableDoubleDataStore;
    }

    protected void convertToPointerRepresentation(ArrayDBIDs arrayDBIDs, DoubleLongHeap doubleLongHeap, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore) {
        FiniteProgress finiteProgress;
        Logging logging = this.getLogger();
        DBIDRef dBIDRef = arrayDBIDs.iter();
        while (dBIDRef.valid()) {
            writableDBIDDataStore.put(dBIDRef, dBIDRef);
            dBIDRef.advance();
        }
        dBIDRef = DBIDUtil.newVar();
        DBIDVar dBIDVar = DBIDUtil.newVar();
        DBIDVar dBIDVar2 = DBIDUtil.newVar();
        FiniteProgress finiteProgress2 = finiteProgress = logging.isVerbose() ? new FiniteProgress("Converting MST to pointer representation", doubleLongHeap.size(), logging) : null;
        while (!doubleLongHeap.isEmpty()) {
            double d = doubleLongHeap.peekKey();
            long l = doubleLongHeap.peekValue();
            int n = (int)(l >>> 31);
            int n2 = (int)(l & Integer.MAX_VALUE);
            arrayDBIDs.assignVar(n, (DBIDVar)dBIDRef);
            while (!DBIDUtil.equal(dBIDRef, writableDBIDDataStore.assignVar(dBIDRef, dBIDVar2))) {
                dBIDRef.set(dBIDVar2);
            }
            arrayDBIDs.assignVar(n2, dBIDVar);
            while (!DBIDUtil.equal(dBIDVar, writableDBIDDataStore.assignVar(dBIDVar, dBIDVar2))) {
                dBIDVar.set(dBIDVar2);
            }
            int n3 = DBIDUtil.compare(dBIDRef, dBIDVar);
            if (n3 < 0) {
                writableDBIDDataStore.put(dBIDRef, dBIDVar);
                writableDoubleDataStore.put(dBIDRef, d);
            } else {
                assert (n3 != 0) : "This should never happen!";
                writableDBIDDataStore.put((DBIDRef)dBIDVar, dBIDRef);
                writableDoubleDataStore.put((DBIDRef)dBIDVar, d);
            }
            doubleLongHeap.poll();
            logging.incrementProcessed(finiteProgress);
        }
        logging.ensureCompleted(finiteProgress);
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            double d = writableDoubleDataStore.doubleValue(dBIDArrayIter);
            writableDBIDDataStore.assignVar(dBIDArrayIter, (DBIDVar)dBIDRef);
            dBIDVar.set(dBIDRef);
            while (d >= writableDoubleDataStore.doubleValue(dBIDVar) && !DBIDUtil.equal(dBIDVar, writableDBIDDataStore.assignVar(dBIDVar, dBIDVar2))) {
                dBIDVar.set(dBIDVar2);
            }
            if (!DBIDUtil.equal(dBIDRef, dBIDVar)) {
                if (logging.isDebuggingFinest()) {
                    logging.finest("Correcting parent: " + dBIDRef + " -> " + dBIDVar);
                }
                writableDBIDDataStore.put((DBIDRef)dBIDArrayIter, dBIDVar);
            }
            dBIDArrayIter.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public static abstract class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID MIN_PTS_ID = new OptionID("hdbscan.minPts", "Threshold for minimum number of points in the epsilon-neighborhood of a point (including this point).");
        protected int minPts;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(MIN_PTS_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.minPts = (Integer)intParameter.getValue();
            }
        }
    }

    public static class HeapMSTCollector
    implements PrimsMinimumSpanningTree.Collector {
        private DoubleLongHeap heap;
        private FiniteProgress prog;
        private Logging log;

        public HeapMSTCollector(DoubleLongHeap doubleLongHeap, FiniteProgress finiteProgress, Logging logging) {
            this.heap = doubleLongHeap;
            this.prog = finiteProgress;
            this.log = logging;
        }

        @Override
        public void addEdge(double d, int n, int n2) {
            this.heap.add(d, (long)n << 31 | (long)n2);
            if (this.log != null && this.prog != null) {
                this.log.incrementProcessed(this.prog);
            }
        }
    }

    protected static class HDBSCANAdapter
    implements PrimsMinimumSpanningTree.Adapter<ArrayDBIDs> {
        private ArrayDBIDs ids;
        private DBIDArrayIter q;
        private DBIDArrayIter p;
        private DoubleDataStore coredists;
        private DistanceQuery<?> distq;

        public HDBSCANAdapter(ArrayDBIDs arrayDBIDs, DoubleDataStore doubleDataStore, DistanceQuery<?> distanceQuery) {
            this.ids = arrayDBIDs;
            this.q = arrayDBIDs.iter();
            this.p = arrayDBIDs.iter();
            this.coredists = doubleDataStore;
            this.distq = distanceQuery;
        }

        @Override
        public double distance(ArrayDBIDs arrayDBIDs, int n, int n2) {
            this.p.seek(n);
            this.q.seek(n2);
            double d = this.coredists.doubleValue(this.p);
            double d2 = this.coredists.doubleValue(this.q);
            return MathUtil.max(d, d2, this.distq.distance((DBIDRef)this.p, (DBIDRef)this.q));
        }

        @Override
        public int size(ArrayDBIDs arrayDBIDs) {
            assert (arrayDBIDs == this.ids);
            return this.ids.size();
        }
    }
}

