/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.FarthestPointsInitialMeans;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;

public class FarthestSumPointsInitialMeans<O>
extends FarthestPointsInitialMeans<O> {
    public FarthestSumPointsInitialMeans(RandomFactory randomFactory, boolean bl) {
        super(randomFactory, bl);
    }

    @Override
    public <T extends NumberVector, V extends NumberVector> List<V> chooseInitialMeans(Database database, Relation<T> relation, int n, NumberVectorDistanceFunction<? super T> numberVectorDistanceFunction, NumberVector.Factory<V> factory) {
        int n2;
        DistanceQuery<T> distanceQuery = database.getDistanceQuery(relation, numberVectorDistanceFunction, new Object[0]);
        DBIDs dBIDs = relation.getDBIDs();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3, 0.0);
        ArrayList<V> arrayList = new ArrayList<V>(n);
        DBIDVar dBIDVar = DBIDUtil.randomSample(dBIDs, this.rnd);
        NumberVector numberVector = (NumberVector)relation.get(dBIDVar);
        arrayList.add(factory.newNumberVector(numberVector));
        DBIDVar dBIDVar2 = DBIDUtil.newVar(dBIDVar);
        int n3 = n2 = this.dropfirst ? 0 : 1;
        while (n2 < n) {
            double d = Double.NEGATIVE_INFINITY;
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                double d2 = writableDoubleDataStore.doubleValue(dBIDIter);
                if (d2 == d2) {
                    double d3 = d2 + distanceQuery.distance((T)numberVector, (T)dBIDIter);
                    if (n2 > 0) {
                        writableDoubleDataStore.putDouble(dBIDIter, d3);
                    }
                    if (d3 > d) {
                        d = d3;
                        dBIDVar2.set(dBIDIter);
                    }
                }
                dBIDIter.advance();
            }
            if (n2 == 0) {
                arrayList.clear();
            }
            writableDoubleDataStore.putDouble(dBIDVar2, Double.NaN);
            numberVector = (NumberVector)relation.get(dBIDVar2);
            arrayList.add(factory.newNumberVector(numberVector));
            ++n2;
        }
        writableDoubleDataStore.destroy();
        return arrayList;
    }

    @Override
    public DBIDs chooseInitialMedoids(int n, DBIDs dBIDs, DistanceQuery<? super O> distanceQuery) {
        int n2;
        Relation<O> relation = distanceQuery.getRelation();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3, 0.0);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n);
        DBIDVar dBIDVar = DBIDUtil.randomSample(dBIDs, this.rnd);
        arrayModifiableDBIDs.add(dBIDVar);
        DBIDVar dBIDVar2 = DBIDUtil.newVar(dBIDVar);
        DBIDVar dBIDVar3 = DBIDUtil.newVar(dBIDVar);
        int n3 = n2 = this.dropfirst ? 0 : 1;
        while (n2 < n) {
            double d = Double.NEGATIVE_INFINITY;
            DBIDIter dBIDIter = relation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d2 = writableDoubleDataStore.doubleValue(dBIDIter);
                if (d2 == d2) {
                    double d3 = d2 + distanceQuery.distance((DBIDRef)dBIDVar2, (DBIDRef)dBIDIter);
                    if (n2 > 0) {
                        writableDoubleDataStore.putDouble(dBIDIter, d3);
                    }
                    if (d3 > d) {
                        d = d3;
                        dBIDVar3.set(dBIDIter);
                    }
                }
                dBIDIter.advance();
            }
            if (n2 == 0) {
                arrayModifiableDBIDs.clear();
            }
            writableDoubleDataStore.putDouble(dBIDVar3, Double.NaN);
            dBIDVar2.set(dBIDVar3);
            arrayModifiableDBIDs.add(dBIDVar3);
            ++n2;
        }
        writableDoubleDataStore.destroy();
        return arrayModifiableDBIDs;
    }

    public static class Parameterizer<V>
    extends FarthestPointsInitialMeans.Parameterizer<V> {
        protected boolean keepfirst = false;

        @Override
        protected FarthestSumPointsInitialMeans<V> makeInstance() {
            return new FarthestSumPointsInitialMeans(this.rnd, !this.keepfirst);
        }
    }
}

