/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.CorrelationClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.GeneralizedOPTICS;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.IndexBasedDistanceFunction;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.HiSCPreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Finding Hierarchies of Subspace Clusters")
@Description(value="Algorithm for detecting hierarchies of subspace clusters.")
@Reference(authors="E. Achtert, C. B\u00f6hm, H.-P. Kriegel, P. Kr\u00f6ger, I. M\u00fcller-Gorman, A. Zimek", title="Finding Hierarchies of Subspace Clusters", booktitle="Proc. 10th Europ. Conf. on Principles and Practice of Knowledge Discovery in Databases (PKDD'06), Berlin, Germany, 2006", url="http://www.dbs.ifi.lmu.de/Publikationen/Papers/PKDD06-HiSC.pdf")
public class HiSC<V extends NumberVector>
extends GeneralizedOPTICS<V, CorrelationClusterOrder> {
    private static final Logging LOG = Logging.getLogger(HiSC.class);
    private IndexFactory<V, HiSCPreferenceVectorIndex<NumberVector>> indexfactory;
    private double alpha;

    public HiSC(IndexFactory<V, HiSCPreferenceVectorIndex<NumberVector>> indexFactory, double d) {
        this.indexfactory = indexFactory;
        this.alpha = d;
    }

    @Override
    public ClusterOrder run(Database database, Relation<V> relation) {
        return new Instance(database, relation).run();
    }

    public double weightedDistance(V v, V v2, long[] lArray) {
        double d = 0.0;
        int n = BitsUtil.nextSetBit(lArray, 0);
        while (n >= 0) {
            double d2 = v.doubleValue(n) - v2.doubleValue(n);
            d += d2 * d2;
            n = BitsUtil.nextSetBit(lArray, n + 1);
        }
        return Math.sqrt(d);
    }

    @Override
    public int getMinPts() {
        return 2;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.indexfactory.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID EPSILON_ID = new OptionID("hisc.epsilon", "The maximum distance between two vectors with equal preference vectors before considering them as parallel.");
        private IndexFactory<V, HiSCPreferenceVectorIndex<NumberVector>> indexfactory;
        double alpha;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(HiSCPreferenceVectorIndex.Factory.ALPHA_ID, 0.01);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
            ListParameterization listParameterization = new ListParameterization();
            listParameterization.addParameter(IndexBasedDistanceFunction.INDEX_ID, HiSCPreferenceVectorIndex.Factory.class);
            listParameterization.addParameter(HiSCPreferenceVectorIndex.Factory.ALPHA_ID, this.alpha);
            ChainedParameterization chainedParameterization = new ChainedParameterization(listParameterization, parameterization);
            chainedParameterization.errorsTo(parameterization);
            Class clazz = ClassGenericsUtil.uglyCrossCast(HiSCPreferenceVectorIndex.Factory.class, IndexFactory.class);
            this.indexfactory = (IndexFactory)chainedParameterization.tryInstantiate(clazz);
        }

        @Override
        protected HiSC<V> makeInstance() {
            return new HiSC<V>(this.indexfactory, this.alpha);
        }
    }

    private class Instance
    extends GeneralizedOPTICS.Instance<V, CorrelationClusterOrder> {
        private HiSCPreferenceVectorIndex<NumberVector> index;
        private ArrayModifiableDBIDs clusterOrder;
        private Relation<V> relation;
        private WritableIntegerDataStore correlationValue;
        private WritableDataStore<long[]> commonPreferenceVectors;

        public Instance(Database database, Relation<V> relation) {
            super(database, relation);
            DBIDs dBIDs = relation.getDBIDs();
            this.clusterOrder = DBIDUtil.newArray(dBIDs.size());
            this.relation = relation;
            this.correlationValue = DataStoreUtil.makeIntegerStorage(dBIDs, 30, Integer.MAX_VALUE);
            this.commonPreferenceVectors = DataStoreUtil.makeStorage(dBIDs, 1, long[].class);
        }

        @Override
        public CorrelationClusterOrder run() {
            this.index = (HiSCPreferenceVectorIndex)HiSC.this.indexfactory.instantiate(this.relation);
            return (CorrelationClusterOrder)super.run();
        }

        @Override
        protected CorrelationClusterOrder buildResult() {
            return new CorrelationClusterOrder("HiCO Cluster Order", "hico-cluster-order", this.clusterOrder, this.reachability, this.predecessor, this.correlationValue);
        }

        @Override
        protected void initialDBID(DBIDRef dBIDRef) {
            this.correlationValue.put(dBIDRef, Integer.MAX_VALUE);
            this.commonPreferenceVectors.put(dBIDRef, new long[0]);
        }

        @Override
        protected void expandDBID(DBIDRef dBIDRef) {
            this.clusterOrder.add(dBIDRef);
            long[] lArray = this.index.getPreferenceVector(dBIDRef);
            NumberVector numberVector = (NumberVector)this.relation.get(dBIDRef);
            int n = numberVector.getDimensionality();
            DBIDIter dBIDIter = this.relation.iterDBIDs();
            while (dBIDIter.valid()) {
                if (!this.processedIDs.contains(dBIDIter)) {
                    int n2;
                    long[] lArray2 = this.index.getPreferenceVector(dBIDIter);
                    NumberVector numberVector2 = (NumberVector)this.relation.get(dBIDIter);
                    long[] lArray3 = BitsUtil.andCMin(lArray, lArray2);
                    int n3 = n - BitsUtil.cardinality(lArray3);
                    double d = HiSC.this.weightedDistance(numberVector, numberVector2, lArray);
                    double d2 = HiSC.this.weightedDistance(numberVector, numberVector2, lArray2);
                    if (d > HiSC.this.alpha || d2 > HiSC.this.alpha) {
                        ++n3;
                        if (LOG.isDebugging()) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("dist1 ").append(d);
                            stringBuilder.append("\ndist2 ").append(d2);
                            stringBuilder.append("\nsubspaceDim ").append(n3);
                            stringBuilder.append("\ncommon pv ").append(BitsUtil.toStringLow(lArray3, n));
                            LOG.debugFine(stringBuilder.toString());
                        }
                    }
                    if ((n2 = this.correlationValue.intValue(dBIDIter)) >= n3) {
                        double d3;
                        double d4 = HiSC.this.weightedDistance(numberVector, numberVector2, lArray3);
                        if (n2 != n3 || !((d3 = this.reachability.doubleValue(dBIDIter)) <= d4)) {
                            this.correlationValue.putInt(dBIDIter, n3);
                            this.reachability.putDouble(dBIDIter, d4);
                            this.predecessor.putDBID(dBIDIter, dBIDRef);
                            this.commonPreferenceVectors.put(dBIDIter, lArray3);
                            if (n2 == Integer.MAX_VALUE) {
                                this.candidates.add(dBIDIter);
                            }
                        }
                    }
                }
                dBIDIter.advance();
            }
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            int n;
            int n2 = this.correlationValue.intValue(dBIDRef);
            return n2 < (n = this.correlationValue.intValue(dBIDRef2)) ? -1 : (n2 > n ? 1 : super.compare(dBIDRef, dBIDRef2));
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

