/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.em.EM;
import de.lmu.ifi.dbs.elki.algorithm.clustering.em.EMClusterModel;
import de.lmu.ifi.dbs.elki.algorithm.clustering.em.MultivariateGaussianModel;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.Subspace;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.MutableProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ChiSquaredDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.PoissonDistribution;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.NumberParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Title(value="P3C: A Robust Projected Clustering Algorithm.")
@Reference(authors="Gabriela Moise, J\u00f6rg Sander, Martin Ester", title="P3C: A Robust Projected Clustering Algorithm", booktitle="Proc. Sixth International Conference on Data Mining (ICDM '06)", url="http://dx.doi.org/10.1109/ICDM.2006.123")
public class P3C<V extends NumberVector>
extends AbstractAlgorithm<Clustering<SubspaceModel>>
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(P3C.class);
    protected double poissonThreshold;
    protected int maxEmIterations;
    protected double emDelta;
    protected int minClusterSize;
    protected double alpha = 0.001;

    public P3C(double d, double d2, int n, double d3, int n2) {
        this.alpha = d;
        this.poissonThreshold = d2;
        this.maxEmIterations = n;
        this.emDelta = d3;
        this.minClusterSize = n2;
    }

    public Clustering<SubspaceModel> run(Database database, Relation<V> relation) {
        int n;
        Object object;
        SetDBIDs[] setDBIDsArray;
        StepProgress stepProgress;
        int n2 = RelationUtil.dimensionality(relation);
        StepProgress stepProgress2 = stepProgress = LOG.isVerbose() ? new StepProgress(8) : null;
        if (stepProgress != null) {
            stepProgress.beginStep(1, "Grid-partitioning data.", LOG);
        }
        int n3 = (int)Math.ceil(1.0 + MathUtil.log2(relation.size()));
        SetDBIDs[][] setDBIDsArray2 = this.partitionData(relation, n3);
        if (stepProgress != null) {
            stepProgress.beginStep(2, "Searching for non-uniform bins in support histograms.", LOG);
        }
        long[][] lArrayArray = new long[n2][];
        for (int i = 0; i < n2; ++i) {
            setDBIDsArray = setDBIDsArray2[i];
            if (setDBIDsArray == null) continue;
            lArrayArray[i] = BitsUtil.zero(n3);
            object = lArrayArray[i];
            for (int j = 0; j < n2 - 1 && (n = this.chiSquaredUniformTest(setDBIDsArray, (long[])object, j)) >= 0; ++j) {
                BitsUtil.setI((long[])object, n);
            }
            if (!LOG.isDebugging()) continue;
            LOG.debug("Marked bins in dim " + i + ": " + BitsUtil.toString((long[])object, n3));
        }
        if (stepProgress != null) {
            stepProgress.beginStep(3, "Merging marked bins to 1-signatures.", LOG);
        }
        ArrayList<Signature> arrayList = this.constructOneSignatures(setDBIDsArray2, lArrayArray);
        if (stepProgress != null) {
            stepProgress.beginStep(4, "Computing cluster cores from merged p-signatures.", LOG);
        }
        setDBIDsArray = this.mergeClusterCores(n3, arrayList);
        if (stepProgress != null) {
            stepProgress.beginStep(5, "Pruning redundant cluster cores.", LOG);
        }
        setDBIDsArray = this.pruneRedundantClusterCores((ArrayList<Signature>)setDBIDsArray);
        if (LOG.isVerbose()) {
            LOG.verbose("Number of cluster cores found: " + setDBIDsArray.size());
        }
        if (setDBIDsArray.size() == 0) {
            LOG.setCompleted(stepProgress);
            object = new Clustering("P3C", "P3C");
            ((Clustering)object).addToplevelCluster(new Cluster(relation.getDBIDs(), true));
            return object;
        }
        if (stepProgress != null) {
            stepProgress.beginStep(5, "Refining cluster cores to clusters via EM.", LOG);
        }
        object = DBIDUtil.newHashSet();
        WritableDataStore<double[]> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 10, double[].class);
        n = setDBIDsArray.size();
        ArrayList<MultivariateGaussianModel> arrayList2 = new ArrayList<MultivariateGaussianModel>(n);
        this.computeFuzzyMembership(relation, (ArrayList<Signature>)setDBIDsArray, (ModifiableDBIDs)object, writableDataStore, arrayList2, n2);
        EM.recomputeCovarianceMatrices(relation, writableDataStore, arrayList2);
        this.assignUnassigned(relation, writableDataStore, arrayList2, (ModifiableDBIDs)object);
        double d = EM.assignProbabilitiesToInstances(relation, arrayList2, writableDataStore);
        for (int i = 1; i <= this.maxEmIterations || this.maxEmIterations < 0; ++i) {
            double d2 = d;
            EM.recomputeCovarianceMatrices(relation, writableDataStore, arrayList2);
            d = EM.assignProbabilitiesToInstances(relation, arrayList2, writableDataStore);
            if (LOG.isVerbose()) {
                LOG.verbose("iteration " + i + " - expectation value: " + d);
            }
            if (d - d2 <= this.emDelta) break;
        }
        if (stepProgress != null) {
            stepProgress.beginStep(6, "Generating hard clustering.", LOG);
        }
        ArrayList<ClusterCandidate> arrayList3 = this.hardClustering(writableDataStore, (List<Signature>)setDBIDsArray, relation.getDBIDs());
        if (stepProgress != null) {
            stepProgress.beginStep(7, "Looking for outliers and moving them to the noise set.", LOG);
        }
        this.findOutliers(relation, arrayList2, arrayList3, (ModifiableDBIDs)object);
        if (stepProgress != null) {
            stepProgress.beginStep(8, "Removing empty clusters.", LOG);
        }
        Object object2 = arrayList3.iterator();
        while (object2.hasNext()) {
            ClusterCandidate clusterCandidate = object2.next();
            int n4 = clusterCandidate.ids.size();
            if (n4 >= this.minClusterSize) continue;
            if (n4 > 0) {
                object.addDBIDs(clusterCandidate.ids);
            }
            object2.remove();
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Number of clusters remaining: " + arrayList3.size());
        }
        if (stepProgress != null) {
            stepProgress.beginStep(9, "Generating final result.", LOG);
        }
        object2 = new Clustering("P3C", "P3C");
        for (int i = 0; i < arrayList3.size(); ++i) {
            ClusterCandidate clusterCandidate = arrayList3.get(i);
            CovarianceMatrix covarianceMatrix = CovarianceMatrix.make(relation, clusterCandidate.ids);
            ((Clustering)object2).addToplevelCluster(new Cluster<SubspaceModel>((DBIDs)clusterCandidate.ids, new SubspaceModel(new Subspace(clusterCandidate.dimensions), covarianceMatrix.getMeanVector())));
        }
        LOG.verbose("Noise size: " + object.size());
        if (object.size() > 0) {
            ((Clustering)object2).addToplevelCluster(new Cluster((DBIDs)object, true));
        }
        LOG.ensureCompleted(stepProgress);
        return object2;
    }

    private ArrayList<Signature> constructOneSignatures(SetDBIDs[][] setDBIDsArray, long[][] lArray) {
        int n = setDBIDsArray.length;
        ArrayList<Signature> arrayList = new ArrayList<Signature>();
        for (int i = 0; i < n; ++i) {
            DBIDs[] dBIDsArray = setDBIDsArray[i];
            if (dBIDsArray == null) continue;
            long[] lArray2 = lArray[i];
            int n2 = BitsUtil.nextSetBit(lArray2, 0);
            while (n2 >= 0) {
                int n3 = BitsUtil.nextClearBit(lArray2, n2 + 1);
                n3 = n3 == -1 ? n : n3;
                int[] nArray = new int[n << 1];
                Arrays.fill(nArray, -1);
                nArray[i << 1] = n2;
                nArray[(i << 1) + 1] = n3 - 1;
                HashSetModifiableDBIDs hashSetModifiableDBIDs = this.unionDBIDs(dBIDsArray, n2, n3);
                if (LOG.isDebugging()) {
                    LOG.debug("1-signature: " + i + " " + n2 + "-" + (n3 - 1));
                }
                arrayList.add(new Signature(nArray, hashSetModifiableDBIDs));
                n2 = n3 < n ? BitsUtil.nextSetBit(lArray2, n3 + 1) : -1;
            }
        }
        return arrayList;
    }

    private ArrayList<Signature> mergeClusterCores(int n, ArrayList<Signature> arrayList) {
        MutableProgress mutableProgress = LOG.isVerbose() ? new MutableProgress("Merging signatures", arrayList.size(), LOG) : null;
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = arrayList.get(i).getFirstDim();
        }
        LOG.debug("First dimensions: " + FormatUtil.format(nArray));
        ArrayList<Signature> arrayList2 = new ArrayList<Signature>(arrayList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            Signature signature = arrayList2.get(i);
            int n2 = signature.getFirstDim();
            for (int j = 0; j < arrayList.size() && nArray[j] < n2; ++j) {
                Signature signature2 = arrayList.get(j);
                Signature signature3 = this.mergeSignatures(signature, signature2, n);
                if (signature3 == null) continue;
                arrayList2.add(signature3);
                signature.prune = true;
                signature2.prune = true;
            }
            if (mutableProgress == null) continue;
            mutableProgress.setTotal(arrayList2.size());
            mutableProgress.incrementProcessed(LOG);
        }
        if (mutableProgress != null) {
            mutableProgress.setProcessed(mutableProgress.getTotal(), LOG);
        }
        return arrayList2;
    }

    private ArrayList<Signature> pruneRedundantClusterCores(ArrayList<Signature> arrayList) {
        ArrayList<Signature> arrayList2 = new ArrayList<Signature>(arrayList.size());
        block0: for (Signature signature : arrayList) {
            if (signature.prune) continue;
            for (int i = 0; i < arrayList.size(); ++i) {
                Signature signature2 = arrayList.get(i);
                if (signature2 != signature && signature2.isSuperset(signature)) continue block0;
            }
            if (LOG.isDebugging()) {
                LOG.debug("Retained cluster core: " + signature);
            }
            arrayList2.add(signature);
        }
        arrayList = arrayList2;
        return arrayList;
    }

    private SetDBIDs[][] partitionData(Relation<V> relation, int n) {
        int n2 = RelationUtil.dimensionality(relation);
        SetDBIDs[][] setDBIDsArray = new SetDBIDs[n2][n];
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(relation.getDBIDs());
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        VectorUtil.SortDBIDsBySingleDimension sortDBIDsBySingleDimension = new VectorUtil.SortDBIDsBySingleDimension(relation, 0);
        for (int i = 0; i < n2; ++i) {
            sortDBIDsBySingleDimension.setDimension(i);
            arrayModifiableDBIDs.sort(sortDBIDsBySingleDimension);
            dBIDArrayMIter.seek(0);
            double d = ((NumberVector)relation.get(dBIDArrayMIter)).doubleValue(i);
            dBIDArrayMIter.seek(arrayModifiableDBIDs.size() - 1);
            double d2 = (((NumberVector)relation.get(dBIDArrayMIter)).doubleValue(i) - d) / (double)n;
            if (d2 > 0.0) {
                SetDBIDs[] setDBIDsArray2 = setDBIDsArray[i];
                double d3 = d + d2;
                HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
                setDBIDsArray2[0] = hashSetModifiableDBIDs;
                int n3 = 0;
                dBIDArrayMIter.seek(0);
                while (dBIDArrayMIter.valid()) {
                    double d4 = ((NumberVector)relation.get(dBIDArrayMIter)).doubleValue(i);
                    if (d4 <= d3 || n3 == setDBIDsArray2.length - 1) {
                        hashSetModifiableDBIDs.add(dBIDArrayMIter);
                    } else {
                        d3 += d2;
                        hashSetModifiableDBIDs = DBIDUtil.newHashSet();
                        setDBIDsArray2[++n3] = hashSetModifiableDBIDs;
                    }
                    dBIDArrayMIter.advance();
                }
                ++n3;
                while (n3 < setDBIDsArray2.length) {
                    setDBIDsArray2[n3] = hashSetModifiableDBIDs;
                    ++n3;
                }
                continue;
            }
            setDBIDsArray[i] = null;
        }
        return setDBIDsArray;
    }

    protected HashSetModifiableDBIDs unionDBIDs(DBIDs[] dBIDsArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 += dBIDsArray[i].size();
        }
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(n3);
        for (int i = n; i < n2; ++i) {
            hashSetModifiableDBIDs.addDBIDs(dBIDsArray[i]);
        }
        return hashSetModifiableDBIDs;
    }

    private int chiSquaredUniformTest(SetDBIDs[] setDBIDsArray, long[] lArray, int n) {
        int n2 = setDBIDsArray.length - n;
        int n3 = 0;
        int n4 = -1;
        MeanVariance meanVariance = new MeanVariance();
        for (int i = 0; i < setDBIDsArray.length; ++i) {
            if (BitsUtil.get(lArray, i)) continue;
            int n5 = setDBIDsArray[i].size();
            meanVariance.put(n5);
            if (n5 <= n3) continue;
            n3 = n5;
            n4 = i;
        }
        if (meanVariance.getCount() < 1.0 || !(meanVariance.getNaiveVariance() > 0.0)) {
            return -1;
        }
        double d = meanVariance.getNaiveVariance() / meanVariance.getMean();
        double d2 = ChiSquaredDistribution.cdf(d, Math.max(1, n2 - n - 1));
        if (1.0 - this.alpha < d2) {
            return n4;
        }
        return -1;
    }

    private void computeFuzzyMembership(Relation<V> relation, ArrayList<Signature> arrayList, ModifiableDBIDs modifiableDBIDs, WritableDataStore<double[]> writableDataStore, List<MultivariateGaussianModel> list, int n) {
        int n2 = relation.size();
        double d = 1.0 / (double)n2;
        int n3 = arrayList.size();
        double[] dArray = new double[n3];
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            int n4 = 0;
            double[] dArray2 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                if (!arrayList.get((int)i).ids.contains(dBIDIter)) continue;
                dArray2[i] = 1.0;
                ++n4;
            }
            if (n4 > 0) {
                VMath.timesEquals(dArray2, 1.0 / (double)n4);
                VMath.plusTimesEquals(dArray, dArray2, d);
            } else {
                modifiableDBIDs.add(dBIDIter);
            }
            writableDataStore.put(dBIDIter, dArray2);
            dBIDIter.advance();
        }
        double d2 = MathUtil.powi(Math.PI * 2, n);
        for (int i = 0; i < n3; ++i) {
            list.add(new MultivariateGaussianModel(dArray[i], new Vector(n), d2));
        }
    }

    private void assignUnassigned(Relation<V> relation, WritableDataStore<double[]> writableDataStore, List<MultivariateGaussianModel> list, ModifiableDBIDs modifiableDBIDs) {
        if (modifiableDBIDs.size() == 0) {
            return;
        }
        int n = list.size();
        double d = 1.0 / (double)relation.size();
        for (EMClusterModel object : list) {
            object.setWeight(object.getWeight() * (double)(relation.size() - modifiableDBIDs.size()) * d);
        }
        DBIDMIter dBIDMIter = modifiableDBIDs.iter();
        while (dBIDMIter.valid()) {
            NumberVector numberVector = (NumberVector)relation.get(dBIDMIter);
            int n2 = -1;
            MultivariateGaussianModel multivariateGaussianModel = null;
            double d2 = Double.POSITIVE_INFINITY;
            int n3 = 0;
            for (MultivariateGaussianModel multivariateGaussianModel2 : list) {
                double d3 = multivariateGaussianModel2.mahalanobisDistance(numberVector);
                if (d3 < d2) {
                    d2 = d3;
                    n2 = n3;
                    multivariateGaussianModel = multivariateGaussianModel2;
                }
                ++n3;
            }
            Object object = new double[n];
            object[n2] = 1.0;
            multivariateGaussianModel.setWeight(multivariateGaussianModel.getWeight() + d);
            writableDataStore.put(dBIDMIter, (double[])object);
            dBIDMIter.advance();
        }
        modifiableDBIDs.clear();
    }

    private ArrayList<ClusterCandidate> hardClustering(WritableDataStore<double[]> writableDataStore, List<Signature> list, DBIDs dBIDs) {
        int n = list.size();
        ArrayList<ClusterCandidate> arrayList = new ArrayList<ClusterCandidate>();
        for (Signature object : list) {
            arrayList.add(new ClusterCandidate(object));
        }
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double[] dArray = (double[])writableDataStore.get(dBIDIter);
            int n2 = 0;
            double d = dArray[0];
            for (int i = 1; i < n; ++i) {
                if (!(dArray[i] > d)) continue;
                n2 = i;
                d = dArray[i];
            }
            arrayList.get((int)n2).ids.add(dBIDIter);
            dBIDIter.advance();
        }
        return arrayList;
    }

    private void findOutliers(Relation<V> relation, List<MultivariateGaussianModel> list, ArrayList<ClusterCandidate> arrayList, ModifiableDBIDs modifiableDBIDs) {
        Iterator<MultivariateGaussianModel> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MultivariateGaussianModel multivariateGaussianModel = iterator.next();
            ClusterCandidate clusterCandidate = arrayList.get(n);
            int n2 = BitsUtil.cardinality(clusterCandidate.dimensions);
            double d = ChiSquaredDistribution.quantile(1.0 - this.alpha, n2);
            DBIDMIter dBIDMIter = clusterCandidate.ids.iter();
            while (dBIDMIter.valid()) {
                double d2 = multivariateGaussianModel.mahalanobisDistance((NumberVector)relation.get(dBIDMIter));
                if (d2 >= d) {
                    modifiableDBIDs.add(dBIDMIter);
                    dBIDMIter.remove();
                }
                dBIDMIter.advance();
            }
            ++n;
        }
    }

    protected Signature mergeSignatures(Signature signature, Signature signature2, int n) {
        int n2 = -1;
        for (int i = 0; i < signature2.spec.length; i += 2) {
            if (signature2.spec[i] < 0) continue;
            assert (n2 == -1) : "Merging with non-1-signature?!?";
            n2 = i;
        }
        assert (n2 >= 0) : "Merging with empty signature?";
        if (signature.spec[n2] >= 0) {
            return null;
        }
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.intersection(signature.ids, signature2.ids);
        int n3 = modifiableDBIDs.size();
        double d = ((double)(signature2.spec[n2 + 1] - signature2.spec[n2]) + 1.0) / (double)n;
        double d2 = (double)signature.ids.size() * d;
        if ((double)n3 <= d2 || n3 < this.minClusterSize) {
            return null;
        }
        double d3 = PoissonDistribution.rawProbability(n3, d2);
        if (this.poissonThreshold <= d3) {
            return null;
        }
        int[] nArray = (int[])signature.spec.clone();
        nArray[n2] = signature2.spec[n2];
        nArray[n2 + 1] = signature2.spec[n2];
        Signature signature3 = new Signature(nArray, modifiableDBIDs);
        if (LOG.isDebugging()) {
            LOG.debug(signature3.toString());
        }
        return signature3;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID ALPHA_THRESHOLD_ID = new OptionID("p3c.alpha", "The significance level for uniform testing in the initial binning step.");
        public static final OptionID POISSON_THRESHOLD_ID = new OptionID("p3c.threshold", "The threshold value for the poisson test used when merging signatures.");
        public static final OptionID MAX_EM_ITERATIONS_ID = new OptionID("p3c.em.maxiter", "The maximum number of iterations for the EM step. Use -1 to run until delta convergence.");
        public static final OptionID EM_DELTA_ID = new OptionID("p3c.em.delta", "The change delta for the EM step below which to stop.");
        public static final OptionID MIN_CLUSTER_SIZE_ID = new OptionID("p3c.minsize", "The minimum size of a cluster, otherwise it is seen as noise (this is a cheat, it is not mentioned in the paper).");
        protected double alpha;
        protected double poissonThreshold;
        protected int maxEmIterations;
        protected double emDelta;
        protected int minClusterSize;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            NumberParameter numberParameter = new DoubleParameter(ALPHA_THRESHOLD_ID, 0.001);
            numberParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            numberParameter.addConstraint(CommonConstraints.LESS_THAN_HALF_DOUBLE);
            if (parameterization.grab(numberParameter)) {
                this.alpha = (Double)numberParameter.getValue();
            }
            numberParameter = new DoubleParameter(POISSON_THRESHOLD_ID, 1.0E-4);
            numberParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            numberParameter.addConstraint(CommonConstraints.LESS_THAN_HALF_DOUBLE);
            if (parameterization.grab(numberParameter)) {
                this.poissonThreshold = (Double)numberParameter.getValue();
            }
            numberParameter = new IntParameter(MAX_EM_ITERATIONS_ID, 20);
            numberParameter.addConstraint(CommonConstraints.GREATER_EQUAL_MINUSONE_INT);
            if (parameterization.grab(numberParameter)) {
                this.maxEmIterations = (Integer)numberParameter.getValue();
            }
            numberParameter = new DoubleParameter(EM_DELTA_ID, 1.0E-5);
            numberParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(numberParameter)) {
                this.emDelta = (Double)numberParameter.getValue();
            }
            numberParameter = new IntParameter(MIN_CLUSTER_SIZE_ID, 1);
            numberParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(numberParameter)) {
                this.minClusterSize = (Integer)numberParameter.getValue();
            }
        }

        @Override
        protected P3C<V> makeInstance() {
            return new P3C(this.alpha, this.poissonThreshold, this.maxEmIterations, this.emDelta, this.minClusterSize);
        }
    }

    private static class ClusterCandidate {
        public final long[] dimensions;
        public final ModifiableDBIDs ids;

        public ClusterCandidate(Signature signature) {
            this.dimensions = BitsUtil.zero(signature.spec.length >> 1);
            for (int i = 0; i < signature.spec.length; i += 2) {
                BitsUtil.setI(this.dimensions, i >> 1);
            }
            this.ids = DBIDUtil.newArray(signature.ids.size());
        }
    }

    private static class Signature {
        int[] spec;
        DBIDs ids;
        boolean prune = false;

        private Signature(int[] nArray, DBIDs dBIDs) {
            this.spec = nArray;
            this.ids = dBIDs;
        }

        public boolean isSuperset(Signature signature) {
            for (int i = 0; i < this.spec.length; i += 2) {
                if (this.spec[i] == signature.spec[i] && this.spec[i + 1] == signature.spec[i] || signature.spec[i] == -1) continue;
                return false;
            }
            return true;
        }

        public int getFirstDim() {
            for (int i = 0; i < this.spec.length; i += 2) {
                if (this.spec[i] < 0) continue;
                return i >>> 1;
            }
            return -1;
        }

        public String toString() {
            int n = 0;
            for (int i = 0; i < this.spec.length; i += 2) {
                if (this.spec[i] < 0) continue;
                ++n;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n).append("-signature: ");
            for (int i = 0; i < this.spec.length; i += 2) {
                if (this.spec[i] < 0) continue;
                stringBuilder.append(i >>> 1).append(':');
                stringBuilder.append(this.spec[i]).append('-').append(this.spec[i + 1]).append(' ');
            }
            stringBuilder.append(" size: ").append(this.ids.size());
            return stringBuilder.toString();
        }
    }
}

