/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique;

import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique.CLIQUEInterval;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique.CLIQUEUnit;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.Subspace;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CLIQUESubspace<V extends NumberVector>
extends Subspace {
    private List<CLIQUEUnit<V>> denseUnits = new ArrayList<CLIQUEUnit<V>>();
    private int coverage = 0;

    public CLIQUESubspace(int n) {
        super(n);
    }

    public CLIQUESubspace(long[] lArray) {
        super(lArray);
    }

    public void addDenseUnit(CLIQUEUnit<V> cLIQUEUnit) {
        ArrayList<CLIQUEInterval> arrayList = cLIQUEUnit.getIntervals();
        for (CLIQUEInterval cLIQUEInterval : arrayList) {
            if (BitsUtil.get(this.getDimensions(), cLIQUEInterval.getDimension())) continue;
            throw new IllegalArgumentException("Unit " + cLIQUEUnit + "cannot be added to this subspace, because of wrong dimensions!");
        }
        this.getDenseUnits().add(cLIQUEUnit);
        this.coverage += cLIQUEUnit.numberOfFeatureVectors();
    }

    public List<Pair<Subspace, ModifiableDBIDs>> determineClusters() {
        ArrayList<Pair<Subspace, ModifiableDBIDs>> arrayList = new ArrayList<Pair<Subspace, ModifiableDBIDs>>();
        for (CLIQUEUnit<V> cLIQUEUnit : this.getDenseUnits()) {
            if (cLIQUEUnit.isAssigned()) continue;
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
            CLIQUESubspace<V> cLIQUESubspace = new CLIQUESubspace<V>(this.getDimensions());
            arrayList.add(new Pair<CLIQUESubspace<V>, HashSetModifiableDBIDs>(cLIQUESubspace, hashSetModifiableDBIDs));
            this.dfs(cLIQUEUnit, hashSetModifiableDBIDs, cLIQUESubspace);
        }
        return arrayList;
    }

    public void dfs(CLIQUEUnit<V> cLIQUEUnit, ModifiableDBIDs modifiableDBIDs, CLIQUESubspace<V> cLIQUESubspace) {
        modifiableDBIDs.addDBIDs(cLIQUEUnit.getIds());
        cLIQUEUnit.markAsAssigned();
        cLIQUESubspace.addDenseUnit(cLIQUEUnit);
        long[] lArray = this.getDimensions();
        int n = BitsUtil.nextSetBit(lArray, 0);
        while (n >= 0) {
            CLIQUEUnit<V> cLIQUEUnit2;
            CLIQUEUnit<V> cLIQUEUnit3 = this.leftNeighbor(cLIQUEUnit, n);
            if (cLIQUEUnit3 != null && !cLIQUEUnit3.isAssigned()) {
                this.dfs(cLIQUEUnit3, modifiableDBIDs, cLIQUESubspace);
            }
            if ((cLIQUEUnit2 = this.rightNeighbor(cLIQUEUnit, n)) != null && !cLIQUEUnit2.isAssigned()) {
                this.dfs(cLIQUEUnit2, modifiableDBIDs, cLIQUESubspace);
            }
            n = BitsUtil.nextSetBit(lArray, n + 1);
        }
    }

    public CLIQUEUnit<V> leftNeighbor(CLIQUEUnit<V> cLIQUEUnit, int n) {
        CLIQUEInterval cLIQUEInterval = cLIQUEUnit.getInterval(n);
        for (CLIQUEUnit<V> cLIQUEUnit2 : this.getDenseUnits()) {
            if (!cLIQUEUnit2.containsLeftNeighbor(cLIQUEInterval)) continue;
            return cLIQUEUnit2;
        }
        return null;
    }

    public CLIQUEUnit<V> rightNeighbor(CLIQUEUnit<V> cLIQUEUnit, Integer n) {
        CLIQUEInterval cLIQUEInterval = cLIQUEUnit.getInterval(n);
        for (CLIQUEUnit<V> cLIQUEUnit2 : this.getDenseUnits()) {
            if (!cLIQUEUnit2.containsRightNeighbor(cLIQUEInterval)) continue;
            return cLIQUEUnit2;
        }
        return null;
    }

    public int getCoverage() {
        return this.coverage;
    }

    public List<CLIQUEUnit<V>> getDenseUnits() {
        return this.denseUnits;
    }

    public CLIQUESubspace<V> join(CLIQUESubspace<V> cLIQUESubspace, double d, double d2) {
        long[] lArray = this.joinLastDimensions(cLIQUESubspace);
        if (lArray == null) {
            return null;
        }
        CLIQUESubspace<V> cLIQUESubspace2 = new CLIQUESubspace<V>(lArray);
        for (CLIQUEUnit<V> cLIQUEUnit : this.getDenseUnits()) {
            for (CLIQUEUnit<V> cLIQUEUnit2 : cLIQUESubspace.getDenseUnits()) {
                CLIQUEUnit<V> cLIQUEUnit3 = cLIQUEUnit.join(cLIQUEUnit2, d, d2);
                if (cLIQUEUnit3 == null) continue;
                cLIQUESubspace2.addDenseUnit(cLIQUEUnit3);
            }
        }
        if (cLIQUESubspace2.getDenseUnits().isEmpty()) {
            return null;
        }
        return cLIQUESubspace2;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString(string));
        stringBuilder.append('\n').append(string).append("Coverage: ").append(this.coverage);
        stringBuilder.append('\n').append(string).append("Units: \n");
        for (CLIQUEUnit<V> cLIQUEUnit : this.getDenseUnits()) {
            stringBuilder.append(string).append("   ").append(cLIQUEUnit.toString()).append("   ").append(cLIQUEUnit.getIds().size()).append(" objects\n");
        }
        return stringBuilder.toString();
    }

    public static class CoverageComparator
    implements Comparator<CLIQUESubspace<?>> {
        @Override
        public int compare(CLIQUESubspace<?> cLIQUESubspace, CLIQUESubspace<?> cLIQUESubspace2) {
            return -(cLIQUESubspace.getCoverage() - cLIQUESubspace2.getCoverage());
        }
    }
}

