/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.uncertain.DiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Reference(authors="M. Chau, R. Cheng, B. Kao, J. Ng", title="Uncertain data mining: An example in clustering location data", booktitle="Proc. 10th Pacific-Asia Conference on Knowledge Discovery and Data Mining (PAKDD 2006)", url="http://dx.doi.org/10.1007/11731139_24")
public class UKMeans
extends AbstractAlgorithm<Clustering<KMeansModel>>
implements ClusteringAlgorithm<Clustering<KMeansModel>> {
    protected static final Logging LOG = Logging.getLogger(UKMeans.class);
    protected static final String KEY = UKMeans.class.getName();
    protected int k;
    protected int maxiter;
    protected RandomFactory rnd;

    public UKMeans(int n, int n2, RandomFactory randomFactory) {
        this.k = n;
        this.maxiter = n2;
        this.rnd = randomFactory;
    }

    public Clustering<?> run(Database database, Relation<DiscreteUncertainObject> relation) {
        int n;
        if (relation.size() <= 0) {
            return new Clustering("Uk-Means Clustering", "ukmeans-clustering");
        }
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample(relation.getDBIDs(), this.k, this.rnd);
        List<Vector> list = new ArrayList<Vector>(this.k);
        Object object = modifiableDBIDs.iter();
        while (object.valid()) {
            list.add(new Vector(ArrayLikeUtil.toPrimitiveDoubleArray(relation.get((DBIDRef)object).getCenterOfMass())));
            object.advance();
        }
        object = new ArrayList();
        for (int i = 0; i < this.k; ++i) {
            object.add(DBIDUtil.newHashSet((int)((double)relation.size() * 2.0 / (double)this.k)));
        }
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
        double[] dArray = new double[this.k];
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("UK-Means iteration", LOG) : null;
        DoubleStatistic doubleStatistic = LOG.isStatistics() ? new DoubleStatistic(this.getClass().getName() + ".variance-sum") : null;
        for (n = 0; this.maxiter <= 0 || n < this.maxiter; ++n) {
            LOG.incrementProcessed(indefiniteProgress);
            boolean bl = this.assignToNearestCluster(relation, list, (List<? extends ModifiableDBIDs>)object, writableIntegerDataStore, dArray);
            this.logVarstat(doubleStatistic, dArray);
            if (!bl) break;
            list = this.means((List<? extends ModifiableDBIDs>)object, list, relation);
        }
        LOG.setCompleted(indefiniteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", n));
        }
        Clustering<KMeansModel> clustering = new Clustering<KMeansModel>("Uk-Means Clustering", "ukmeans-clustering");
        for (int i = 0; i < object.size(); ++i) {
            DBIDs dBIDs = (DBIDs)object.get(i);
            if (dBIDs.size() == 0) continue;
            KMeansModel kMeansModel = new KMeansModel(list.get(i), dArray[i]);
            clustering.addToplevelCluster(new Cluster<KMeansModel>(dBIDs, kMeansModel));
        }
        return clustering;
    }

    protected boolean assignToNearestCluster(Relation<DiscreteUncertainObject> relation, List<Vector> list, List<? extends ModifiableDBIDs> list2, WritableIntegerDataStore writableIntegerDataStore, double[] dArray) {
        assert (this.k == list.size());
        boolean bl = false;
        Arrays.fill(dArray, 0.0);
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d = Double.POSITIVE_INFINITY;
            DiscreteUncertainObject discreteUncertainObject = relation.get(dBIDIter);
            int n = 0;
            for (int i = 0; i < this.k; ++i) {
                double d2 = this.getExpectedRepDistance(list.get(i), discreteUncertainObject);
                if (!(d2 < d)) continue;
                n = i;
                d = d2;
            }
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
            bl |= this.updateAssignment(dBIDIter, list2, writableIntegerDataStore, n);
            dBIDIter.advance();
        }
        return bl;
    }

    protected boolean updateAssignment(DBIDIter dBIDIter, List<? extends ModifiableDBIDs> list, WritableIntegerDataStore writableIntegerDataStore, int n) {
        int n2 = writableIntegerDataStore.intValue(dBIDIter);
        if (n2 == n) {
            return false;
        }
        list.get(n).add(dBIDIter);
        writableIntegerDataStore.putInt(dBIDIter, n);
        if (n2 >= 0) {
            list.get(n2).remove(dBIDIter);
        }
        return true;
    }

    protected double getExpectedRepDistance(Vector vector, DiscreteUncertainObject discreteUncertainObject) {
        SquaredEuclideanDistanceFunction squaredEuclideanDistanceFunction = SquaredEuclideanDistanceFunction.STATIC;
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < discreteUncertainObject.getNumberSamples(); ++i) {
            d += squaredEuclideanDistanceFunction.distance(vector, discreteUncertainObject.getSample(i));
            ++n;
        }
        return d / (double)n;
    }

    protected List<Vector> means(List<? extends ModifiableDBIDs> list, List<? extends NumberVector> list2, Relation<DiscreteUncertainObject> relation) {
        ArrayList<Vector> arrayList = new ArrayList<Vector>(this.k);
        for (int i = 0; i < this.k; ++i) {
            ModifiableDBIDs modifiableDBIDs = list.get(i);
            Vector vector = null;
            if (modifiableDBIDs.size() > 0) {
                DBIDMIter dBIDMIter = modifiableDBIDs.iter();
                double[] dArray = ArrayLikeUtil.toPrimitiveDoubleArray(relation.get(dBIDMIter).getCenterOfMass());
                vector = new Vector(dArray);
                assert (dArray == vector.getArrayRef());
                dBIDMIter.advance();
                while (dBIDMIter.valid()) {
                    DoubleVector doubleVector = relation.get(dBIDMIter).getCenterOfMass();
                    for (int j = 0; j < vector.getDimensionality(); ++j) {
                        int n = j;
                        dArray[n] = dArray[n] + doubleVector.doubleValue(j);
                    }
                    dBIDMIter.advance();
                }
                vector.timesEquals(1.0 / (double)modifiableDBIDs.size());
            } else {
                vector = list2.get(i).getColumnVector();
            }
            arrayList.add(vector);
        }
        return arrayList;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.UNCERTAIN_OBJECT_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    protected void logVarstat(DoubleStatistic doubleStatistic, double[] dArray) {
        if (doubleStatistic == null) {
            return;
        }
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        doubleStatistic.setDouble(d);
        this.getLogger().statistics(doubleStatistic);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected int k;
        protected int maxiter;
        protected RandomFactory rnd;

        @Override
        public void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            IntParameter intParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter2 = (IntParameter)new IntParameter(KMeans.K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.k = (Integer)intParameter2.getValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(KMeans.MAXITER_ID, 0).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT))) {
                this.maxiter = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(KMeans.SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected UKMeans makeInstance() {
            return new UKMeans(this.k, this.maxiter, this.rnd);
        }
    }
}

