/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="P. J. Rousseeuw", title="Silhouettes: A graphical aid to the interpretation and validation of cluster analysis", booktitle="Journal of Computational and Applied Mathematics, Volume 20", url="http://dx.doi.org/10.1016%2F0377-0427%2887%2990125-7")
public class SilhouetteOutlierDetection<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SilhouetteOutlierDetection.class);
    ClusteringAlgorithm<?> clusterer;
    private NoiseHandling noiseOption = NoiseHandling.TREAT_NOISE_AS_SINGLETONS;

    public SilhouetteOutlierDetection(DistanceFunction<? super O> distanceFunction, ClusteringAlgorithm<?> clusteringAlgorithm, NoiseHandling noiseHandling) {
        super(distanceFunction);
        this.clusterer = clusteringAlgorithm;
        this.noiseOption = noiseHandling;
    }

    @Override
    public OutlierResult run(Database database) {
        Cluster cluster2;
        Relation relation = database.getRelation(this.getDistanceFunction().getInputTypeRestriction(), new Object[0]);
        DistanceQuery distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        Object obj = this.clusterer.run(database);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        List list = ((Clustering)obj).getAllClusters();
        block8: for (Cluster cluster2 : list) {
            Object object;
            if (cluster2.size() <= 1 || cluster2.isNoise()) {
                switch (this.noiseOption) {
                    case IGNORE_NOISE: 
                    case TREAT_NOISE_AS_SINGLETONS: {
                        object = cluster2.getIDs().iter();
                        while (object.valid()) {
                            writableDoubleDataStore.put((DBIDRef)object, 0.0);
                            object.advance();
                        }
                        doubleMinMax.put(0.0);
                        continue block8;
                    }
                }
            }
            object = DBIDUtil.ensureArray(cluster2.getIDs());
            double[] dArray = new double[object.size()];
            DBIDArrayIter dBIDArrayIter = object.iter();
            DBIDArrayIter dBIDArrayIter2 = object.iter();
            dBIDArrayIter.seek(0);
            while (dBIDArrayIter.valid()) {
                double d;
                double d2 = dArray[dBIDArrayIter.getOffset()];
                dBIDArrayIter2.seek(dBIDArrayIter.getOffset() + 1);
                while (dBIDArrayIter2.valid()) {
                    d = distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDArrayIter2);
                    d2 += d;
                    int n = dBIDArrayIter2.getOffset();
                    dArray[n] = dArray[n] + d;
                    dBIDArrayIter2.advance();
                }
                d2 /= (double)(object.size() - 1);
                d = Double.POSITIVE_INFINITY;
                block12: for (Cluster cluster3 : list) {
                    double d3;
                    Object object2;
                    if (cluster3 == cluster2) continue;
                    if (cluster3.isNoise()) {
                        switch (this.noiseOption) {
                            case IGNORE_NOISE: {
                                continue block12;
                            }
                            case MERGE_NOISE: {
                                break;
                            }
                            case TREAT_NOISE_AS_SINGLETONS: {
                                object2 = cluster3.getIDs().iter();
                                while (object2.valid()) {
                                    d3 = distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)object2);
                                    if (d3 < d) {
                                        d = d3;
                                    }
                                    object2.advance();
                                }
                                continue block12;
                            }
                        }
                    }
                    object2 = cluster3.getIDs();
                    d3 = 0.0;
                    DBIDIter dBIDIter = object2.iter();
                    while (dBIDIter.valid()) {
                        d3 += distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDIter);
                        dBIDIter.advance();
                    }
                    if (!((d3 /= (double)object2.size()) < d)) continue;
                    d = d3;
                }
                double d4 = (d - d2) / Math.max(d, d2);
                writableDoubleDataStore.put((DBIDRef)dBIDArrayIter, d4);
                doubleMinMax.put(d4);
                dBIDArrayIter.advance();
            }
        }
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Silhouette Coefficients", "silhouette-outlier", writableDoubleDataStore, relation.getDBIDs());
        cluster2 = new InvertedOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), -1.0, 1.0, 0.5);
        return new OutlierResult((OutlierScoreMeta)((Object)cluster2), materializedDoubleRelation);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation[] typeInformationArray;
        TypeInformation typeInformation = this.getDistanceFunction().getInputTypeRestriction();
        for (TypeInformation typeInformation2 : typeInformationArray = this.clusterer.getInputTypeRestriction()) {
            if (!typeInformation.isAssignableFromType(typeInformation2)) continue;
            return typeInformationArray;
        }
        TypeInformation[] typeInformationArray2 = new TypeInformation[typeInformationArray.length + 1];
        typeInformationArray2[0] = typeInformation;
        System.arraycopy(typeInformationArray, 0, typeInformationArray2, 1, typeInformationArray.length);
        return typeInformationArray2;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID CLUSTERING_ID = new OptionID("silhouette.clustering", "Clustering algorithm to use for the silhouette coefficients.");
        ClusteringAlgorithm<?> clusterer;
        private NoiseHandling noiseOption = NoiseHandling.TREAT_NOISE_AS_SINGLETONS;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<NoiseHandling> enumParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(CLUSTERING_ID, ClusteringAlgorithm.class);
            if (parameterization.grab(objectParameter)) {
                this.clusterer = (ClusteringAlgorithm)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<NoiseHandling>(EvaluateSilhouette.Parameterizer.NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected SilhouetteOutlierDetection<O> makeInstance() {
            return new SilhouetteOutlierDetection(this.distanceFunction, this.clusterer, this.noiseOption);
        }
    }
}

