/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;

@Title(value="LoOP: Local Outlier Probabilities")
@Description(value="Variant of the LOF algorithm normalized using statistical values.")
@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="LoOP: Local Outlier Probabilities", booktitle="Proceedings of the 18th International Conference on Information and Knowledge Management (CIKM), Hong Kong, China, 2009", url="http://dx.doi.org/10.1145/1645953.1646195")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LoOP"})
public class LoOP<O>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LoOP.class);
    int kreach;
    int kcomp;
    double lambda;
    protected DistanceFunction<? super O> reachabilityDistanceFunction;
    protected DistanceFunction<? super O> comparisonDistanceFunction;

    public LoOP(int n, int n2, DistanceFunction<? super O> distanceFunction, DistanceFunction<? super O> distanceFunction2, double d) {
        this.kreach = n;
        this.kcomp = n2;
        this.reachabilityDistanceFunction = distanceFunction;
        this.comparisonDistanceFunction = distanceFunction2;
        this.lambda = d;
    }

    protected Pair<KNNQuery<O>, KNNQuery<O>> getKNNQueries(Database database, Relation<O> relation, StepProgress stepProgress) {
        KNNQuery<? super O> kNNQuery;
        KNNQuery<? super O> kNNQuery2;
        if (this.comparisonDistanceFunction == this.reachabilityDistanceFunction || this.comparisonDistanceFunction.equals(this.reachabilityDistanceFunction)) {
            LOG.beginStep(stepProgress, 1, "Materializing neighborhoods with respect to reference neighborhood distance function.");
            kNNQuery = kNNQuery2 = DatabaseUtil.precomputedKNNQuery(database, relation, this.comparisonDistanceFunction, MathUtil.max(this.kcomp, this.kreach) + 1);
        } else {
            LOG.beginStep(stepProgress, 1, "Not materializing distance functions, since we request each DBID once only.");
            kNNQuery2 = QueryUtil.getKNNQuery(relation, this.comparisonDistanceFunction, this.kreach + 1);
            kNNQuery = QueryUtil.getKNNQuery(relation, this.reachabilityDistanceFunction, this.kcomp + 1);
        }
        return new Pair<KNNQuery<O>, KNNQuery<O>>(kNNQuery2, kNNQuery);
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress(5) : null;
        Pair<KNNQuery<O>, KNNQuery<O>> pair = this.getKNNQueries(database, relation, stepProgress);
        KNNQuery<O> kNNQuery = pair.getFirst();
        KNNQuery<O> kNNQuery2 = pair.getSecond();
        if (kNNQuery == null) {
            throw new AbortException("No kNN queries supported by database for comparison distance function.");
        }
        if (kNNQuery2 == null) {
            throw new AbortException("No kNN queries supported by database for density estimation distance function.");
        }
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30);
        LOG.beginStep(stepProgress, 3, "Computing pdists");
        this.computePDists(relation, kNNQuery2, writableDoubleDataStore);
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        LOG.beginStep(stepProgress, 4, "Computing PLOF");
        double d = this.computePLOFs(relation, kNNQuery, writableDoubleDataStore, writableDoubleDataStore2);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        LOG.beginStep(stepProgress, 5, "Computing LoOP scores");
        Object object = LOG.isVerbose() ? new FiniteProgress("LoOP for objects", relation.size(), LOG) : null;
        double d2 = 1.0 / (d * MathUtil.SQRT2);
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d3 = NormalDistribution.erf((writableDoubleDataStore2.doubleValue(dBIDIter) - 1.0) * d2);
            writableDoubleDataStore2.putDouble(dBIDIter, d3);
            doubleMinMax.put(d3);
            LOG.incrementProcessed((AbstractProgress)object);
            dBIDIter.advance();
        }
        LOG.ensureCompleted((FiniteProgress)object);
        LOG.setCompleted(stepProgress);
        object = new MaterializedDoubleRelation("Local Outlier Probabilities", "loop-outlier", writableDoubleDataStore2, relation.getDBIDs());
        ProbabilisticOutlierScore probabilisticOutlierScore = new ProbabilisticOutlierScore(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0);
        return new OutlierResult(probabilisticOutlierScore, (DoubleRelation)object);
    }

    protected void computePDists(Relation<O> relation, KNNQuery<O> kNNQuery, WritableDoubleDataStore writableDoubleDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("pdists", relation.size(), LOG) : null;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.kreach + 1);
            int n = 0;
            double d = 0.0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid() && n < this.kreach) {
                if (!DBIDUtil.equal(doubleDBIDListIter, dBIDIter)) {
                    double d2 = doubleDBIDListIter.doubleValue();
                    d += d2 * d2;
                    ++n;
                }
                doubleDBIDListIter.advance();
            }
            double d3 = n > 0 ? Math.sqrt(d / (double)n) : 0.0;
            writableDoubleDataStore.putDouble(dBIDIter, d3);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    protected double computePLOFs(Relation<O> relation, KNNQuery<O> kNNQuery, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("PLOFs for objects", relation.size(), LOG) : null;
        double d = 0.0;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.kcomp + 1);
            int n = 0;
            double d2 = 0.0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid() && n < this.kcomp) {
                if (!DBIDUtil.equal(doubleDBIDListIter, dBIDIter)) {
                    d2 += writableDoubleDataStore.doubleValue(doubleDBIDListIter);
                    ++n;
                }
                doubleDBIDListIter.advance();
            }
            double d3 = MathUtil.max(writableDoubleDataStore.doubleValue(dBIDIter) * (double)n / d2, 1.0);
            if (Double.isNaN(d3) || Double.isInfinite(d3)) {
                d3 = 1.0;
            }
            writableDoubleDataStore2.putDouble(dBIDIter, d3);
            d += (d3 - 1.0) * (d3 - 1.0);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        d = this.lambda * Math.sqrt(d / (double)relation.size());
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("nplof normalization factor is " + d);
        }
        return d > 0.0 ? d : 1.0;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation typeInformation = this.reachabilityDistanceFunction.equals(this.comparisonDistanceFunction) ? this.reachabilityDistanceFunction.getInputTypeRestriction() : new CombinedTypeInformation(this.reachabilityDistanceFunction.getInputTypeRestriction(), this.comparisonDistanceFunction.getInputTypeRestriction());
        return TypeUtil.array(typeInformation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID REACHABILITY_DISTANCE_FUNCTION_ID = new OptionID("loop.referencedistfunction", "Distance function to determine the density of an object.");
        public static final OptionID COMPARISON_DISTANCE_FUNCTION_ID = new OptionID("loop.comparedistfunction", "Distance function to determine the reference set of an object.");
        public static final OptionID KREACH_ID = new OptionID("loop.kref", "The number of nearest neighbors of an object to be used for the PRD value.");
        public static final OptionID KCOMP_ID = new OptionID("loop.kcomp", "The number of nearest neighbors of an object to be considered for computing its LOOP_SCORE.");
        public static final OptionID LAMBDA_ID = new OptionID("loop.lambda", "The number of standard deviations to consider for density computation.");
        int kreach = 0;
        int kcomp = 0;
        double lambda = 2.0;
        protected DistanceFunction<O> reachabilityDistanceFunction = null;
        protected DistanceFunction<O> comparisonDistanceFunction = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(KCOMP_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.kcomp = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(COMPARISON_DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class))) {
                this.comparisonDistanceFunction = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            IntParameter intParameter2 = new IntParameter(KREACH_ID);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            intParameter2.setOptional(true);
            this.kreach = parameterization.grab(intParameter2) ? intParameter2.intValue() : this.kcomp;
            ObjectParameter objectParameter2 = new ObjectParameter(REACHABILITY_DISTANCE_FUNCTION_ID, DistanceFunction.class, true);
            if (parameterization.grab(objectParameter2)) {
                this.reachabilityDistanceFunction = (DistanceFunction)objectParameter2.instantiateClass(parameterization);
            }
            DoubleParameter doubleParameter = new DoubleParameter(LAMBDA_ID, 2.0);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.lambda = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LoOP<O> makeInstance() {
            DistanceFunction<O> distanceFunction = this.reachabilityDistanceFunction != null ? this.reachabilityDistanceFunction : this.comparisonDistanceFunction;
            return new LoOP<O>(this.kreach, this.kcomp, distanceFunction, this.comparisonDistanceFunction, this.lambda);
        }
    }
}

