/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.AbstractPrecomputedNeighborhood;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class ExtendedNeighborhood
extends AbstractPrecomputedNeighborhood {
    private static final Logging LOG = Logging.getLogger(ExtendedNeighborhood.class);

    public ExtendedNeighborhood(DataStore<DBIDs> dataStore) {
        super(dataStore);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "Extended Neighborhood";
    }

    @Override
    public String getShortName() {
        return "extended-neighborhood";
    }

    public static class Factory<O>
    extends AbstractPrecomputedNeighborhood.Factory<O> {
        private NeighborSetPredicate.Factory<O> inner;
        private int steps;

        public Factory(NeighborSetPredicate.Factory<O> factory, int n) {
            this.inner = factory;
            this.steps = n;
        }

        @Override
        public NeighborSetPredicate instantiate(Database database, Relation<? extends O> relation) {
            DataStore<DBIDs> dataStore = this.extendNeighborhood(database, relation);
            ExtendedNeighborhood extendedNeighborhood = new ExtendedNeighborhood(dataStore);
            return extendedNeighborhood;
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.inner.getInputTypeRestriction();
        }

        private DataStore<DBIDs> extendNeighborhood(Database database, Relation<? extends O> relation) {
            NeighborSetPredicate neighborSetPredicate = this.inner.instantiate(database, relation);
            WritableDataStore<DBIDs> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 7, DBIDs.class);
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Expanding neighborhoods", relation.size(), LOG) : null;
            DBIDIter dBIDIter = relation.iterDBIDs();
            while (dBIDIter.valid()) {
                HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
                hashSetModifiableDBIDs.add(dBIDIter);
                SetDBIDs setDBIDs = DBIDUtil.deref(dBIDIter);
                for (int i = 0; i < this.steps; ++i) {
                    HashSetModifiableDBIDs hashSetModifiableDBIDs2 = DBIDUtil.newHashSet();
                    DBIDIter dBIDIter2 = setDBIDs.iter();
                    while (dBIDIter2.valid()) {
                        DBIDs dBIDs = neighborSetPredicate.getNeighborDBIDs(dBIDIter2);
                        if (dBIDs != null) {
                            DBIDIter dBIDIter3 = dBIDs.iter();
                            while (dBIDIter3.valid()) {
                                if (!hashSetModifiableDBIDs.contains(dBIDIter3)) {
                                    hashSetModifiableDBIDs2.add(dBIDIter3);
                                    hashSetModifiableDBIDs.add(dBIDIter3);
                                }
                                dBIDIter3.advance();
                            }
                        }
                        dBIDIter2.advance();
                    }
                    if (hashSetModifiableDBIDs2.size() == 0) continue;
                    setDBIDs = hashSetModifiableDBIDs2;
                }
                writableDataStore.put(dBIDIter, hashSetModifiableDBIDs);
                LOG.incrementProcessed(finiteProgress);
                dBIDIter.advance();
            }
            LOG.ensureCompleted(finiteProgress);
            return writableDataStore;
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID NEIGHBORHOOD_ID = new OptionID("extendedneighbors.neighborhood", "The inner neighborhood predicate to use.");
            public static final OptionID STEPS_ID = new OptionID("extendedneighbors.steps", "The number of steps allowed in the neighborhood graph.");
            private int steps;
            private NeighborSetPredicate.Factory<O> inner;

            protected static <O> NeighborSetPredicate.Factory<O> getParameterInnerNeighborhood(Parameterization parameterization) {
                ObjectParameter objectParameter = new ObjectParameter(NEIGHBORHOOD_ID, NeighborSetPredicate.Factory.class);
                if (parameterization.grab(objectParameter)) {
                    return (NeighborSetPredicate.Factory)objectParameter.instantiateClass(parameterization);
                }
                return null;
            }

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                this.inner = Parameterizer.getParameterInnerNeighborhood(parameterization);
                this.steps = Parameterizer.getParameterSteps(parameterization);
            }

            public static int getParameterSteps(Parameterization parameterization) {
                IntParameter intParameter = new IntParameter(STEPS_ID);
                intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    return (Integer)intParameter.getValue();
                }
                return 1;
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.inner, this.steps);
            }
        }
    }
}

