/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;

public class TrivialNoOutlier
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(TrivialNoOutlier.class);

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.ANY);
    }

    public OutlierResult run(Relation<?> relation) {
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 2);
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            writableDoubleDataStore.putDouble((DBIDRef)object, 0.0);
            object.advance();
        }
        object = new MaterializedDoubleRelation("Trivial no-outlier score", "no-outlier", writableDoubleDataStore, relation.getDBIDs());
        ProbabilisticOutlierScore probabilisticOutlierScore = new ProbabilisticOutlierScore();
        return new OutlierResult(probabilisticOutlierScore, (DoubleRelation)object);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

