/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelOrAllInOneClustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.scores.AbstractScoreEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.HistogramResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.DoubleStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="Ranking Quality Histogram")
@Description(value="Evaluates the effectiveness of a distance function via the obtained rankings.")
public class RankingQualityHistogram<O>
extends AbstractDistanceBasedAlgorithm<O, CollectionResult<DoubleVector>> {
    private static final Logging LOG = Logging.getLogger(RankingQualityHistogram.class);
    protected int numbins = 100;

    public RankingQualityHistogram(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.numbins = n;
    }

    public HistogramResult<DoubleVector> run(Database database, Relation<O> relation) {
        Object object;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, relation.size());
        if (LOG.isVerbose()) {
            LOG.verbose("Preprocessing clusters...");
        }
        List list = ((Clustering)new ByLabelOrAllInOneClustering().run(database)).getAllClusters();
        DoubleStaticHistogram doubleStaticHistogram = new DoubleStaticHistogram(this.numbins, 0.0, 1.0);
        if (LOG.isVerbose()) {
            LOG.verbose("Processing points...");
        }
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing ROC AUC values", relation.size(), LOG) : null;
        MeanVariance meanVariance = new MeanVariance();
        for (Cluster histogramResult2 : list) {
            object = histogramResult2.getIDs().iter();
            while (object.valid()) {
                KNNList kNNList = kNNQuery.getKNNForDBID((DBIDRef)object, relation.size());
                double d = ((AbstractScoreEvaluation)new ROCEvaluation()).evaluate(histogramResult2, (DoubleDBIDList)kNNList);
                meanVariance.put(d);
                doubleStaticHistogram.increment(d, 1.0 / (double)relation.size());
                LOG.incrementProcessed(finiteProgress);
                object.advance();
            }
        }
        LOG.ensureCompleted(finiteProgress);
        ArrayList arrayList = new ArrayList(relation.size());
        DoubleStaticHistogram.Iter iter = doubleStaticHistogram.iter();
        while (iter.valid()) {
            object = new DoubleVector(new double[]{iter.getCenter(), iter.getValue()});
            arrayList.add(object);
            iter.advance();
        }
        HistogramResult<DoubleVector> histogramResult = new HistogramResult<DoubleVector>("Ranking Quality Histogram", "ranking-histogram", arrayList);
        histogramResult.addHeader("Mean: " + meanVariance.getMean() + " Variance: " + meanVariance.getSampleVariance());
        return histogramResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID HISTOGRAM_BINS_ID = new OptionID("rankqual.bins", "Number of bins to use in the histogram");
        protected int numbins = 20;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(HISTOGRAM_BINS_ID, 100);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.numbins = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected RankingQualityHistogram<O> makeInstance() {
            return new RankingQualityHistogram(this.distanceFunction, this.numbins);
        }
    }
}

